/**
 * Source file created in 2011 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.domain.common.dao.impl;


import gov.va.med.pharmacy.peps.domain.common.dao.EplNationalSettingDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplNationalSettingDo;

import java.util.List;

import org.hibernate.Query;
import org.springframework.stereotype.Repository;


/**
 * EplNationalSettingDaoImpl
 */
//@Repository
public class EplNationalSettingDaoImpl extends DataAccessObjectImpl<EplNationalSettingDo, Long> 
            implements EplNationalSettingDao {
    public static final String FIND_BY_KEY_NAME = "findByKeyName";
    public static final String KEY_NAME = "keyName";
    /**
     * Inherited from the AutoAddDAO interface. Finds an all EplFileDo object in ascending order from the database.
     * 
     * @return Collection of EplFileDo objects
     */
    @Override
    public List<EplNationalSettingDo> retrieve() {
        return retrieveNationalSettings(EplNationalSettingDo.ID);
    }
    
    @Override
    public EplNationalSettingDo findByKeyName(String key){
        Query query= getCurrentSession().getNamedQuery(FIND_BY_KEY_NAME);
       query.setString("keyName", key);
       return (EplNationalSettingDo) query.uniqueResult();
    }
}
