package gov.va.med.pharmacy.peps.domain.common.dao.impl;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.pharmacy.peps.domain.common.dao.EplMatchTypeDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplMatchTypeDo;

public class EplMatchTypeDaoImpl extends DataAccessObjectImpl<EplMatchTypeDo, Long> implements EplMatchTypeDao {
    
    @Autowired
    private SessionFactory sessionFactory;
    
    @Override
    @Autowired
    public SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    /**
     * @param sessionFactory the sessionFactory to set
     */
    @Override
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public EplMatchTypeDo findById(Long id) {
        if(id == null){
            throw new IllegalArgumentException("RematchSuggestion id cannot be null");
        }
        
        Session session = getSessionFactory().getCurrentSession();        
        EplMatchTypeDo eplMatchTypeDo = (EplMatchTypeDo) session.get(EplMatchTypeDo.class, id);
        
        return eplMatchTypeDo;
    }

}
