package gov.va.med.pharmacy.peps.domain.common.dao.impl;


import gov.va.med.pharmacy.peps.domain.common.dao.EplDrugDrugInteractionDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplDrugDrugInteractionDo;

import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;



/**
 * @author serverbutts
 *
 */
@Repository
public class EplDrugDrugInteractionDaoImpl extends DataAccessObjectImpl<EplDrugDrugInteractionDo, Long> implements EplDrugDrugInteractionDao   {
      
    @Autowired
    private SessionFactory sessionFactory;
    
    public SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    /**
     * @param sessionFactory the sessionFactory to set
     */
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
    
    
    @Override
    public List<EplDrugDrugInteractionDo> retrieve() {
        return retrieveAscending(EplDrugDrugInteractionDo.DRUG_INTERACTION_NAME);
    }
    
    
    /**
     * Find By Id
     */

    @Override
    public EplDrugDrugInteractionDo findById(Long id) {
        
        if(id == null){
            throw new IllegalArgumentException("EplDrugDrugInteraction id cannot be null");
        }
        
        Session session = getSessionFactory().getCurrentSession();
        
        EplDrugDrugInteractionDo eplDrugDrugInteraction = (EplDrugDrugInteractionDo) session.get(EplDrugDrugInteractionDo.class, id);
        
        return eplDrugDrugInteraction;
    }

    
    @SuppressWarnings("unchecked")
    @Override
    public List<EplDrugDrugInteractionDo> retrieveDrugDrugInteractions(String interactionName) {
                
        Session session = getSessionFactory().getCurrentSession();
        Query query = session.getNamedQuery("findDrugDrugInteractionByName")
          .setString("interactionName", interactionName);
            
        List<EplDrugDrugInteractionDo> drugInteractions = query.list();
        
        return drugInteractions;
        
    }

    
    /**
     * Save
     */
    @Override
    public EplDrugDrugInteractionDo save(EplDrugDrugInteractionDo eplDrugDrugInteractions) {
        
        EplDrugDrugInteractionDo drugInteractions = new EplDrugDrugInteractionDo();
        
        Session session = getSessionFactory().getCurrentSession();
        
        Long id = (Long) session.save(eplDrugDrugInteractions);
        
        drugInteractions = findById(id);
        
        return drugInteractions;
    }

    
   /**
    * Update
    */
    @Override
    public EplDrugDrugInteractionDo update(EplDrugDrugInteractionDo eplDrugDrugInteractions) {
        
        Session session = getSessionFactory().getCurrentSession();
        session.update(eplDrugDrugInteractions);
        return eplDrugDrugInteractions;
    }
     

}
    
    
