package gov.va.med.pharmacy.peps.domain.common.dao.impl;


import gov.va.med.pharmacy.peps.domain.common.dao.EplDdiSeverityDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplDdiSeverityDo;

import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;



/**
 * @author serverbutts
 *
 */
@Repository
public class EplDdiSeverityDaoImpl extends DataAccessObjectImpl<EplDdiSeverityDo, Long> implements EplDdiSeverityDao {
      
    @Autowired
    private SessionFactory sessionFactory;
    
    @Override
    public EplDdiSeverityDo findByName(String name){
        Query query = getCurrentSession().getNamedQuery("findSeverityByName");
        query.setString("severity", name);
        return (EplDdiSeverityDo) query.uniqueResult();
      
    }
    
    public SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    /**
     * @param sessionFactory the sessionFactory to set
     */
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
    
    

    @Override
    public List<EplDdiSeverityDo> retrieveAll() {
        
        return retrieveAscending(EplDdiSeverityDo.SEVERITY_NAME);
    }

    @Override
    public EplDdiSeverityDo retrieve(Integer Id) {
        
        if(Id == null){
            throw new IllegalArgumentException("id cannot be null");
        }
        
        Session session = getSessionFactory().getCurrentSession();
        
        EplDdiSeverityDo eplDdiSeverity = (EplDdiSeverityDo) session.get(EplDdiSeverityDo.class, Id);
       
        return eplDdiSeverity;
    }
    
   

 
    

}
    
    
