package gov.va.med.pharmacy.peps.domain.common.dao;


import java.util.Date;
import java.util.List;

import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.pharmacy.peps.common.vo.NdfUpdateFileVo;
import gov.va.med.pharmacy.peps.domain.common.model.EplRematchSuggestionDo;


public interface EplRematchSuggestionDao extends DataAccessObject<EplRematchSuggestionDo, Long>{
    
    @Autowired
    public abstract SessionFactory getSessionFactory();

    public abstract void setSessionFactory(SessionFactory sessionFactory);

    
    /**
     * @param id
     * @return EplRematchSuggestionDo
     */
    public abstract EplRematchSuggestionDo findById(Long id);

    
    /**
     * @param eplRematchSuggestion
     * @return EplRematchSuggestionDo
     */
    public abstract EplRematchSuggestionDo save(EplRematchSuggestionDo eplRematchSuggestion);
    
    
    /**
     * @param eplRematchSuggestion
     * @return EplRematchSuggestionDo
     */
    public abstract EplRematchSuggestionDo update(EplRematchSuggestionDo eplRematchSuggestion);


    public List<EplRematchSuggestionDo> findAll();

    public abstract List<Object[]> removeObsoleteInactiveProduct();

    public List<Object[]> removeObsoletePrintName();

    public List<Object[]> removeObsoleteGenericName();

    public List<Object[]> removeObsoleteCMOP();

    public List<Object[]> removeObsoleteDispense();

    public List<Object[]> removeObsoleteDosageForm();

    public List<Object[]> removeObsoleteStrength();

    public List<Object[]> removeObsoleteDrugUnit();

    public List<Object[]> removeObsoleteFedSch();

    public List<Object[]> removeObsoleteFutureInactivated();

    public List<Object[]> loadInactiveProduct();    

    public List<Object[]> loadUnmatchGenericName();

    public List<Object[]> loadUnmatchCMOP();

    public List<Object[]> loadUnmatchDispense();

    public List<Object[]> loadUnmatchPrintName();

    public List<Object[]> loadUnmatchDosageForm();

    public List<Object[]> loadUnmatchStrength();

    public List<Object[]> loadUnmatchDrugUnit();

    public List<Object[]> loadFutureInactivated();

    public List<Object[]> loadUnmatchFedSch();

    public List<Object[]> findRematchAuto(Date startDTM);

    public List<EplRematchSuggestionDo> retrieveByMatchType(Long matchTypeId);

    public abstract Long retrieveProductId(String productIen);

    public List<Object[]> findRematchProducts(Long productId);

    public List<Object[]> findRematchSugg(Date startDTM);

    public abstract void updateRematchNdfUpdateFileFk(Date startDTM, NdfUpdateFileVo ndfUpdateFileVo);

    public List<Object[]> findRematchNoSugg(Date startDTM);

    public abstract void removeNdfUpdateFileFk(Long fileSeqNo);

    public List<Object[]> removeObsoleteOthers();   
    
    
}