/**
 * Source file created in 2006 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.domain.common.dao;


import java.util.List;

import gov.va.med.pharmacy.peps.domain.common.model.EplProductDo;


/**
 * This interface provides a set of operations that may be performed on all the classes that 
 * inherit from this interface.  It provides abstract methods to access and modify the EplProductDo.
 * 
 */
public interface EplProductDao extends DataAccessObject<EplProductDo, Long> {

    public List<Object[]> retrieveInactive();
    
    public List<Object[]> retrieveGcnNdcMap();
    
    /**
     * Retrieve Product objects where the excludeFromRxNormUpdate flag is set to false (or null)
     * 
     * @return list of Product objects
     */
    public List<EplProductDo> retrieveProductsNotExcludedFromRxNormUpdate();

    /**
     * Retrieve Product objects by NDC
     * 
     * @return list of Product objects
     */
    List<EplProductDo> retrieveVaProduct(String ndc);

}
