package gov.va.med.pharmacy.peps.domain.common.dao;

import gov.va.med.pharmacy.peps.domain.common.model.EplPackageSizeDo;

/**
 * This class provides a set of operation that may be performed on all the classes that inherit from this class. This
 * interface should never be used directly, but it will be inherited by all DAOs. It provides abstract methods to access and
 * modify the EplPackageTypeDo.
 * 
 */
public interface EplPackageSizeDao extends DataAccessObject<EplPackageSizeDo, Long> {
    
    public EplPackageSizeDo retrieveByPackageSize(Double packageSize);
    
    public EplPackageSizeDo retrieveById(Long eplId);
}
