package gov.va.med.pharmacy.peps.domain.common.dao;

import gov.va.med.pharmacy.peps.domain.common.model.EplNdfUpdateFileDo;

/**
 * This class provides a set of operation that may be performed on all the classes that inherit from this class. This
 * interface should never be used directly, but it will be inherited by all DAOs. It provides abstract methods to access and
 * modify the EplPartialSaveMgtDo.
 * 
 */
public interface EplNdfUpdateFileDao extends DataAccessObject<EplNdfUpdateFileDo, Long>{
    
    public Long retrieveNextSeq();

    public abstract EplNdfUpdateFileDo retrieveByName(String name);
    
    public abstract EplNdfUpdateFileDo retrieveVistaWaitingByName(String name);

}
