package gov.va.med.pharmacy.peps.domain.common.dao;


import java.util.Date;
import java.util.List;

import gov.va.med.pharmacy.peps.common.vo.NdfUpdateFileVo;
import gov.va.med.pharmacy.peps.domain.common.model.EplNdfOutgoingDifferences;

public interface EplNdfOutgoingDifferencesDao {

    /**
     * Find by id.
     *
     * @param id the id
     * @return the epl ndf outgoing differences
     */
    public abstract EplNdfOutgoingDifferences findById(Long id);

    /**
     * Save.
     *
     * @param eplNdfOutgoingDifferences the epl ndf outgoing differences
     * @return the epl ndf outgoing differences
     */
    public abstract EplNdfOutgoingDifferences save(EplNdfOutgoingDifferences eplNdfOutgoingDifferences);
    
    /**
     * update.
     *
     * @param eplNdfOutgoingDifferences the epl ndf outgoing differences
     * @return the epl ndf outgoing differences
     */
    public abstract EplNdfOutgoingDifferences update(EplNdfOutgoingDifferences eplNdfOutgoingDifferences);
    
    /**
     * update the ndf update_file_fk_field with the generated output file seq number.
     *
     * @param List<EplNdfOutgoingDifferences> returnedDifference date of current processing period
     * @param NdfUpdateFileVo ndfUpdateFile .
     */
    
    public void updateNdfUpdateFileFk(List<EplNdfOutgoingDifferences> returnedDifference, NdfUpdateFileVo ndfUpdateFile);
    
    /**
     * set the ndf update_file_fk_field to null to remove association.
     *
     * @param Long fileSeqNo file seq no to remove.
     */
    
    public void removeNdfUpdateFileFk(Long fileSeqNo);
    
    /**
     * Find updates for current reporting period
     *
     * @param Date the start date
     * @return eplNdfOutgoingDifferences the epl ndf outgoing differences
     */
    public List<EplNdfOutgoingDifferences> retrieveDifferencesForOutputFile(Date startDate);
    
    /**
     * Find by vista file by vista file, field, Ien where data has not been included in an output file yet.
     *
     * @param vista file
     * @param vista field
     * @param vista ien 
     * @return eplNdfOutgoingDifferences the epl ndf outgoing differences
     */
    public EplNdfOutgoingDifferences findByFileFieldIen(String vistaFileNumber, String vistaFieldNumber, String vistaIen);

    /**
     * Find by vista file by vista file and field where data has not been included in an update file.
     *
     * @param vista file
     * @param vista field
     * @return Long the vista Ien
     */
    public List<Object[]> findByFileAndField(String vistaFile, String vistaField, Date startDTM);
    
    /**
     * Find inactive generic name in an update file.
     *
     * @param vista file
     * @param vista field
     * @return String the vista Ien
     */
    public List<String> findInactiveGenericName(String vistaFileNumber, String vistaFieldNumber, Date startDTM);
    
    /**
     * Find inactive generic name in an update file.
     *
     * @param vista file
     * @param vista field
     * @return String the vista Ien
     */
    public List<Object[]> findOverrideDFChkExcl(String vistaFileNumber, String vistaFieldNumber, Date startDTM);
 
    /**
     * Find drug class changes by vista file and field where data has not been included in an update file.
     *
     * @param vista file
     * @param vista field
     * @return List the drug changes
     */   
    public List<Object[]> findDrugClassChanges(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> findActiveNatFormularyProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> findInactiveNatFormularyProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> findInactivatedCMOPProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> findAddedProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> findNewClassProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public EplNdfOutgoingDifferences findModifiedRecords(String vistaFileNumber, String vistaFieldNumber, String vistaIen,
        String actionType);

    public List<Object[]> findUnmatchedProducts(String vistaFileNumber);

    public List<Object[]> findScheduleChangeProducts(String vistaFileNumber, String vistaFieldNumber);

    public List<Object[]> findNoPossibleDosageProducts(String vistaFileNumber, Date startDTM);

    public List<Object[]> findYesPossibleDosageProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> findAddedMedGuideProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> findEditedMedGuideProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> findExcludedDDIProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> findDeletedMedGuideProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> messageGenericChange(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> dispenseUnitsChange(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> drugUnitsChange(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> classChange(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> futureInactiveChange();

    public List<Object[]> scheduleAllChange(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> genNameAllChange(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> dosageFormChange(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> findPrevExcludedDDIProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> findReactivatedProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> findInactivatedProductsForLocal(String vistaFileNumber, Date startDTM);

    public List<Object[]> findInactivatedProducts(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> findAddedDDIs(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> findEditedDDIs(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> findInactivatedDDIs(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> findReactivatedDDIs(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> messageCMOPChange(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> futureInactiveRematched();

    public List<Object[]> findInactiveRematchReport(String vistaFileNumber, String vistaFieldNumber, Date startDTM);

    public List<Object[]> findInactiveRematchReportSugg(String vistaFileNumber, String vistaFieldNumber, Date startDTM);
    
}
