

package gov.va.med.pharmacy.peps.domain.common.capability.impl;


import gov.va.med.pharmacy.peps.common.email.Email;
import gov.va.med.pharmacy.peps.common.email.EmailService;
import gov.va.med.pharmacy.peps.common.object.VistaStatus;
import gov.va.med.pharmacy.peps.common.vo.EplVistaUpdateVo;
import gov.va.med.pharmacy.peps.domain.common.capability.VistaUpdateCapability;
import gov.va.med.pharmacy.peps.domain.common.dao.EplVistaUpdateDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplVistaStatusDo;
import gov.va.med.pharmacy.peps.domain.common.model.EplVistaUpdateDo;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.EplVistaUpdateConverter;

import org.apache.logging.log4j.Logger; 
import org.apache.logging.log4j.LogManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Configuration
@PropertySource("classpath:gov.va.med.pharmacy.peps.emailservice.properties")
public class VistaUpdateCapabilityImpl implements VistaUpdateCapability {
    private static final Logger LOG = LogManager.getLogger(VistaUpdateCapabilityImpl.class);
    @Autowired
    private EplVistaUpdateDao eplVistaUpdateDao;
    
    @Autowired
    private EmailService emailService;
    
    @Autowired
    private Environment environment;

    @Override
    public EplVistaUpdateDo saveUpdate(EplVistaUpdateVo eplVistaUpdate) {
        EplVistaUpdateConverter converter = new EplVistaUpdateConverter();
        LOG.debug(eplVistaUpdate.toString());     
        
        //email notification related code.
        EplVistaUpdateDo vistaUpdateDo = new EplVistaUpdateDo();
        vistaUpdateDo = eplVistaUpdateDao.save(converter.convert(eplVistaUpdate));  
       
        // As of PPS-N 3.0 this e-mail notification has been moved to the Vista Mailman
        // vistaInstallNotification(vistaUpdateDo);
        
        return vistaUpdateDo;
    }
    
//    private void vistaInstallNotification(EplVistaUpdateDo vistaUpdateDo){
//        if( (null!=vistaUpdateDo) && (null!= vistaUpdateDo.getEplNdfUpdateFileDo()) 
//            && (null!=vistaUpdateDo.getEplNdfUpdateFileDo().getEplStatus())){
//        
//            Long statusIdObj = vistaUpdateDo.getEplNdfUpdateFileDo().getEplStatus().getStatusId();
//           
//            if(null!=statusIdObj){
//                
//                int statusId = statusIdObj.intValue();
//                
//                if(statusId ==5){
//                
//                  String toEmailIds = environment.getRequiredProperty("updatefile_to_email"); 
//                  String emailSubject="National Test VistA Installation Completed";
//                  String emailMessage="\n\n The Test VistA instance has processed the update file and is ready for testing. "
//                  + "\n A user may now access the Update approval functionality of PPS-N.";
//    
//                  sendEmailNotification(toEmailIds, emailSubject, emailMessage);
//                }
//                
//            }
//        }
//    }
    
    @Override
    public EplVistaStatusDo getStatus(VistaStatus vistaStatus) {
       return null;
    }

    /**
     * @return the eplVistaUpdateDao
     */
    public EplVistaUpdateDao getEplVistaUpdateDao() {
        return eplVistaUpdateDao;
    }

    /**
     * @param eplVistaUpdateDao the eplVistaUpdateDao to set
     */
    public void setEplVistaUpdateDao(EplVistaUpdateDao eplVistaUpdateDao) {
        this.eplVistaUpdateDao = eplVistaUpdateDao;
    }

    
    /**
     * @return the emailService
     */
    public EmailService getEmailService() {
        return emailService;
    }

    
    /**
     * @param emailService the emailService to set
     */
    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }
    
    /**
     * Sends text email notification.
     * 
     * @param toEmailIds
     * @param emailSubject
     * @param emailMessage
     */
    private void sendEmailNotification(String toEmailIds, String emailSubject, String emailMessage)
    {
        
        try {
            
            Email emailBean = new Email();
            
        /*
         * Need to set to in another way  by converting to an array as setting addresses like emailid1@domain,emailid2@domain
         * Gives error by javax mail Address Parser.
         */
            String[] toEmailId = new String[]{""};
            
            // if toEmailIdStr string is a comma separated string then split it. 
            if(null!=toEmailIds && toEmailIds.length()>0)
            {
                toEmailId = toEmailIds.split(",");
            }               
                    
            
            emailBean.setTo(toEmailId);        
            emailBean.setSubject(emailSubject);        
            emailBean.setEmailMessage(emailSubject);
            
            getEmailService().sendEmail(emailBean);
        
        
        } catch (Exception e) {
            LOG.error("Error in sendEmailNotification" +  e);
        }
    }

  
}
