package gov.va.med.pharmacy.peps.domain.common.capability.impl;

import java.math.BigDecimal;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.pharmacy.peps.common.vo.MatchTypeVo;
import gov.va.med.pharmacy.peps.common.vo.RematchSuggestionVo;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.domain.common.capability.RematchSuggestionMgtDomainCapability;
import gov.va.med.pharmacy.peps.domain.common.dao.EplMatchTypeDao;
import gov.va.med.pharmacy.peps.domain.common.dao.EplRematchSuggestionDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplRematchSuggestionDo;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.MatchTypeConverter;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.RematchSuggestionConverter;



public class RematchSuggestionMgtDomainCapabilityImpl implements RematchSuggestionMgtDomainCapability {
    @Autowired
    private EplRematchSuggestionDao eplRematchSuggestionDao; 
    @Autowired
    private EplMatchTypeDao eplMatchTypeDao; 
    private RematchSuggestionConverter rematchSuggestionConverter;
    private MatchTypeConverter matchTypeConverter;

    @Override
    public List<RematchSuggestionVo> retrieveAll() {
        List<EplRematchSuggestionDo> rematchSuggestions = eplRematchSuggestionDao.findAll();
        return rematchSuggestionConverter.convert(rematchSuggestions);       
    }
    
    @Override
    public void removeObsoleteProducts() {
        
        removeObsoleteEntries(eplRematchSuggestionDao.removeObsoleteInactiveProduct());
        removeObsoleteEntries(eplRematchSuggestionDao.removeObsoleteFutureInactivated());
        removeObsoleteEntries(eplRematchSuggestionDao.removeObsoleteOthers());
        
    }
    
    @Override
    public void addUnmatchedProducts(UserVo user) {
        
        addUnmatchedFutureInactiveEntries(eplRematchSuggestionDao.loadFutureInactivated(), user);
        addUnmatchedEntries(eplRematchSuggestionDao.loadInactiveProduct(), user);
        addUnmatchedEntries(eplRematchSuggestionDao.loadUnmatchCMOP(), user);
        addUnmatchedEntries(eplRematchSuggestionDao.loadUnmatchDispense(), user);
        addUnmatchedEntries(eplRematchSuggestionDao.loadUnmatchDosageForm(), user);
        addUnmatchedEntries(eplRematchSuggestionDao.loadUnmatchDrugUnit(), user);
        addUnmatchedEntries(eplRematchSuggestionDao.loadUnmatchFedSch(), user);
        addUnmatchedEntries(eplRematchSuggestionDao.loadUnmatchGenericName(), user);
        addUnmatchedEntries(eplRematchSuggestionDao.loadUnmatchPrintName(), user);
        addUnmatchedEntries(eplRematchSuggestionDao.loadUnmatchStrength(), user);
        
    }
    
    @Override
    public List<RematchSuggestionVo> retrieveUnmatched(Long matchTypeId) {
        
        List<EplRematchSuggestionDo> rematchSuggestions = eplRematchSuggestionDao.retrieveByMatchType(matchTypeId);
        return rematchSuggestionConverter.convert(rematchSuggestions);         
        
    }
    
    @Override
    public Long retrieveProductId(String productIen) {
        
        Long productId = eplRematchSuggestionDao.retrieveProductId(productIen); 
        
        return productId;
    }   
    
    @Override   
    public List<Object[]> findRematchProducts(Long productId) {
        return eplRematchSuggestionDao.findRematchProducts(productId);
    } 
    
    
    private void addUnmatchedEntries(List<Object[]> addEntries, UserVo user ){
        
        if (addEntries!= null && !addEntries.isEmpty()){
            for (Object[] addEntry : addEntries) {
                String oldIen = (String)addEntry[0];
                BigDecimal matchType = (BigDecimal)addEntry[1];
                RematchSuggestionVo unmatch = new RematchSuggestionVo(); 
                unmatch.setOldIen(oldIen);
                unmatch.setMatchType(createMatchType(matchType.longValue()));
                               
                insert(unmatch, user) ;              
            }
        }
    }
    
    private void addUnmatchedFutureInactiveEntries(List<Object[]> addEntries, UserVo user ){
        
        if (addEntries!= null && !addEntries.isEmpty()){
            for (Object[] addEntry : addEntries) {
                String oldIen = ((BigDecimal)addEntry[0]).toString();
                BigDecimal matchType = (BigDecimal)addEntry[1];
                RematchSuggestionVo unmatch = new RematchSuggestionVo(); 
                unmatch.setOldIen(oldIen);
                unmatch.setMatchType(createMatchType(matchType.longValue()));
                               
                insert(unmatch, user) ;              
            }
        }
    }
    
    /**
     * Creates a status based on incoming status string
     * 
     * @return StatusVo
     */
    private MatchTypeVo createMatchType(Long match) {
        MatchTypeVo matchType = new MatchTypeVo(); 
        
        matchType = matchTypeConverter.convert(eplMatchTypeDao.findById(match));        
                        
        return matchType;        
    } 
    
    private void removeObsoleteEntries(List<Object[]> obsoleteEntries){
        
        if (obsoleteEntries!= null && !obsoleteEntries.isEmpty()){
            for (Object[] obsoleteEntry : obsoleteEntries) {
                BigDecimal id = (BigDecimal)obsoleteEntry[1];
                eplRematchSuggestionDao.delete("eplRematchSuggestionId", id.longValue());                
            }
        }
        
    }
    
    
    public void insert(RematchSuggestionVo unmatch, UserVo user) {
        EplRematchSuggestionDo unmatchDo = rematchSuggestionConverter.convert(unmatch);
        EplRematchSuggestionDo value = eplRematchSuggestionDao.insert(unmatchDo, user);
    }
    
    @Override   
    public RematchSuggestionVo update(Long rematchId, String matchIen, Boolean autoMatch) {
        
        EplRematchSuggestionDo toUpdate = eplRematchSuggestionDao.findById(rematchId);
        toUpdate.setNewIen(matchIen);
        toUpdate.setMatchScope(autoMatch);
        return rematchSuggestionConverter.convert(eplRematchSuggestionDao.update(toUpdate));
    } 
    
    public EplRematchSuggestionDao getEplRematchSuggestionDao() {
        return eplRematchSuggestionDao;
    }

    
    public void setEplRematchSuggestionDao(EplRematchSuggestionDao eplRematchSuggestionDao) {
        this.eplRematchSuggestionDao = eplRematchSuggestionDao;
    }

    
    public RematchSuggestionConverter getRematchSuggestionConverter() {
        return rematchSuggestionConverter;
    }

    
    public void setRematchSuggestionConverter(RematchSuggestionConverter rematchSuggestionConverter) {
        this.rematchSuggestionConverter = rematchSuggestionConverter;
    }

    
    public MatchTypeConverter getMatchTypeConverter() {
        return matchTypeConverter;
    }

    
    public void setMatchTypeConverter(MatchTypeConverter matchTypeConverter) {
        this.matchTypeConverter = matchTypeConverter;
    }

}
