package gov.va.med.pharmacy.peps.domain.common.capability.impl;


import gov.va.med.pharmacy.peps.common.exception.DuplicateItemException;
import gov.va.med.pharmacy.peps.common.exception.ValidationException;
import gov.va.med.pharmacy.peps.common.utility.PPSConstants;
import gov.va.med.pharmacy.peps.common.vo.ManagedItemVo;
import gov.va.med.pharmacy.peps.common.vo.PrimaryIngredientVo;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.domain.common.capability.PrimaryIngredientDomainCapability;
import gov.va.med.pharmacy.peps.domain.common.dao.DataAccessObject;
import gov.va.med.pharmacy.peps.domain.common.dao.EplIngredientDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplIngredientDo;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.PrimaryIngredientConverter;
import gov.va.med.pharmacy.peps.domain.common.utility.querybuilder.HqlBuilder;

import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;



/**
 * @author serverbutts
 *  Perform readonly operations on Ingredients. For Create, Update, Delete, IngredientDomainCapabilityImpl should be used.
 *
 */
public class PrimaryIngredientDomainCapabilityImpl extends  ManagedDataDomainCapabilityImpl<PrimaryIngredientVo, EplIngredientDo>
implements PrimaryIngredientDomainCapability {

    @Autowired
    private EplIngredientDao eplIngredientDao;

    private PrimaryIngredientConverter primaryIngredientConverter;

    /**
     * @param eplIngredientDao the eplIngredientDao to set
     */
    public void setEplIngredientDao(EplIngredientDao eplIngredientDao) {
        this.eplIngredientDao = eplIngredientDao;
    }


    /**
     * @param primaryIngredientConverter the primaryIngredientConverter to set
     */
    public void setPrimaryIngredientConverter(PrimaryIngredientConverter primaryIngredientConverter) {
        this.primaryIngredientConverter = primaryIngredientConverter;
    }


    @Override
    public Converter<PrimaryIngredientVo, EplIngredientDo> getConverter() {       
        return primaryIngredientConverter;
    }

    @Override
    public DataAccessObject getDataAccessObject() {

        return eplIngredientDao;
    }

    @Override
    public PrimaryIngredientVo create(PrimaryIngredientVo managedItem, UserVo user) throws DuplicateItemException {

        return null;
    }

    @Override
    public void checkForActiveDependencies(PrimaryIngredientVo managedItem, UserVo user) throws ValidationException {

    }

    @Override
    public List<ManagedItemVo> retrieveDependencies(PrimaryIngredientVo managedItem) throws ValidationException {

        return null;
    }

    @Override
    public PrimaryIngredientVo createWithoutDuplicateCheck(PrimaryIngredientVo managedItem, UserVo user) {

        return null;
    }

    @Override
    public void delete(PrimaryIngredientVo item) {

    }

    @Override
    public void deleteItem(PrimaryIngredientVo item) throws ValidationException {

    }

    @Override
    public void reassociateAndDelete(PrimaryIngredientVo oldItem, PrimaryIngredientVo newItem, UserVo user) {

    }

    @Override
    public List<PrimaryIngredientVo> retrieveDuplicates(PrimaryIngredientVo managedItem) {
        return null;
    }

    @Override
    public PrimaryIngredientVo update(PrimaryIngredientVo managedItem, UserVo user) throws DuplicateItemException {

        return null;
    }

    @Override
    public boolean existsByUniquenessFields(PrimaryIngredientVo item) {

        return false;
    }



    @Override
    public PrimaryIngredientVo retrieveByName(String name) {

        String name2 = name;

        // replace ' with double tick.
        if (name2.contains("'")) {
            name2 = name2.replace("'", "''");
        }

        StringBuffer query = new StringBuffer();

        query.append(HqlBuilder.create("SELECT item FROM").append(EplIngredientDo.class).append("item"));

        String whereClause = " where name LIKE '" + name2 + "'";

        query.append(whereClause);

        List<EplIngredientDo> returnedDos = eplIngredientDao.executeHqlQuery(query.toString());

        if (returnedDos == null || returnedDos.size() < 1) {
            return null;
        } 

        Collection<PrimaryIngredientVo> vos =  primaryIngredientConverter.convert(returnedDos);

        for (PrimaryIngredientVo vo : vos) {
            if (StringUtils.equals(vo.getValue(), name2)) {
                return vo;
            }
        }

        return null;
    }

    /**
     * Create Hibernate {@link Criteria} that will find an item by its
     * uniqueness fields.
     * 
     * @param item
     *            {@link ManagedItemVo} for which to create uniqueness
     *            {@link Criteria}
     * @return {@link Criteria}
     */
    @Override
    protected
    Criteria createUniquenessCriteria(PrimaryIngredientVo item) {
        Criteria criteria = getDataAccessObject().getCriteria();
        criteria.add(Restrictions.ilike(EplIngredientDo.NAME, item.getValue()));
        return criteria;
    }


    @SuppressWarnings("unchecked")
    public List<PrimaryIngredientVo> retrieve() {

        StringBuffer query = new StringBuffer();

        query.append(HqlBuilder.create("SELECT item FROM ").append(EplIngredientDo.class).append(PPSConstants.ITEM));

        String whereClause = " WHERE EPL_ID_PRIMARY_INGREDIENT_FK  is null order by name asc";

        query.append(whereClause);

        List<EplIngredientDo> activeIngredients = eplIngredientDao.executeHqlQuery(query.toString());

        return primaryIngredientConverter.convertMinimal(activeIngredients);        

    }




}
