package gov.va.med.pharmacy.peps.domain.common.capability.impl;

import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.criterion.Order;

import gov.va.med.pharmacy.peps.common.vo.StatusVo;
import gov.va.med.pharmacy.peps.domain.common.capability.NdfUpdateFileStatusDomainCapability;
import gov.va.med.pharmacy.peps.domain.common.dao.EplStatusDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplStatusDo;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.StatusConverter;

public class NdfUpdateFileStatusDomainCapabilityImpl implements NdfUpdateFileStatusDomainCapability{

    
    private EplStatusDao eplStatusDao;
    
    private StatusConverter statusConverter;

    /**
     * Create the list of values of the StatusVo
     * 
     * @return StatusVo list 
     */
    public List<StatusVo> retrieveAll() {
        Criteria criteria = eplStatusDao.getCriteria();        
        criteria.addOrder(Order.asc(EplStatusDo.STATUS_ID));                        
        List<EplStatusDo> values = criteria.list();
        List<StatusVo> returnedValues = statusConverter.convert(values);

        return returnedValues;
    }

    public EplStatusDao getEplStatusDao() {
        return eplStatusDao;
    }

    public void setEplStatusDao(EplStatusDao eplStatusDao) {
        this.eplStatusDao = eplStatusDao;
    }

    public StatusConverter getStatusConverter() {
        return statusConverter;
    }

    public void setStatusConverter(StatusConverter statusConverter) {
        this.statusConverter = statusConverter;
    }
    
}
