package gov.va.med.pharmacy.peps.domain.common.capability.impl;


import gov.va.med.pharmacy.peps.common.vo.DrugSeverityVo;
import gov.va.med.pharmacy.peps.common.vo.FieldKey;
import gov.va.med.pharmacy.peps.domain.common.capability.DrugSeverityDomainCapability;
import gov.va.med.pharmacy.peps.domain.common.dao.DataAccessObject;
import gov.va.med.pharmacy.peps.domain.common.dao.EplDdiSeverityDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplDdiSeverityDo;
import gov.va.med.pharmacy.peps.domain.common.utility.SchemaUtility;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.DrugSeverityConverter;

import java.util.LinkedHashMap;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;



/**
 * @author serverbutts
 * Perform retrieve operations on drug severity
 */
public class DrugSeverityDomainCapabilityImpl extends ManagedDataDomainCapabilityImpl<DrugSeverityVo, EplDdiSeverityDo>
implements DrugSeverityDomainCapability {


    @Autowired
    private EplDdiSeverityDao eplDdiSeverityDao;

    private DrugSeverityConverter drugSeverityConverter;



    public void setEplDdiSeverityDao(EplDdiSeverityDao eplDdiSeverityDao) {
        this.eplDdiSeverityDao = eplDdiSeverityDao;
    }


    public void setDrugSeverityConverter(DrugSeverityConverter drugSeverityConverter) {
        this.drugSeverityConverter = drugSeverityConverter;
    }

    @Override
    public Converter<DrugSeverityVo, EplDdiSeverityDo> getConverter() {
        return drugSeverityConverter;
    }

    @Override
    public DataAccessObject getDataAccessObject() {
        return eplDdiSeverityDao;
    }

    @Override
    protected Criteria createUniquenessCriteria(DrugSeverityVo item) {

        Criteria criteria = getDataAccessObject().getCriteria();

        criteria.add(Restrictions.ilike(EplDdiSeverityDo.SEVERITY_NAME, item.getValue()));

        return criteria;
    }


    public List<DrugSeverityVo> retrieve() {

        Criteria criteria = getDataAccessObject().getCriteria();

        String sortPropertyName = SchemaUtility.getPropertyName(getDataObjectClass(), FieldKey.VALUE);

        if (sortPropertyName != null && sortPropertyName.trim().length() > 0) {
            Order order = Order.asc(sortPropertyName);
            order.ignoreCase();
            criteria.addOrder(order);
        }

        configureCaching(criteria);
        List<EplDdiSeverityDo> results = criteria.list();

        return getConverter().convertMinimal(results);
    }


    @Override
    public DrugSeverityVo retrieveMinimal(String id) {

        EplDdiSeverityDo  drugSeverityDo = eplDdiSeverityDao.retrieve(Integer.valueOf(id));

        return drugSeverityConverter.convertMinimal(drugSeverityDo);
    }

    @Override
    public LinkedHashMap<String, String> getSeverityMap() {

        List<EplDdiSeverityDo> severityList = eplDdiSeverityDao.retrieveAll();

        LinkedHashMap<String, String> severityMap = new LinkedHashMap<String, String>();

        for (EplDdiSeverityDo severity: severityList){

            severityMap.put(severity.getName(), String.valueOf((severity.getSeverityId())));

        }

        return severityMap;

    }

}
