package gov.va.med.pharmacy.peps.domain.common.capability.impl;


import gov.va.med.pharmacy.peps.common.exception.DuplicateItemException;
import gov.va.med.pharmacy.peps.common.exception.ItemNotFoundException;
import gov.va.med.pharmacy.peps.common.vo.DispenseUnitVo;
import gov.va.med.pharmacy.peps.common.vo.DrugDrugInteractionVo;
import gov.va.med.pharmacy.peps.common.vo.ManagedItemVo;
import gov.va.med.pharmacy.peps.common.vo.RequestItemStatus;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.domain.common.capability.DrugDrugInteractionDomainCapability;
import gov.va.med.pharmacy.peps.domain.common.dao.DataAccessObject;
import gov.va.med.pharmacy.peps.domain.common.dao.EplDrugDrugInteractionDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplDrugDrugInteractionDo;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.Converter;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.DrugDrugInteractionConverter;

import org.hibernate.Criteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author serverbutts
 * Perform CRUD operations on drug drug interaction
 *
 */
@Service
public class DrugDrugInteractionDomainCapabilityImpl extends ManagedDataDomainCapabilityImpl<DrugDrugInteractionVo, EplDrugDrugInteractionDo>
implements DrugDrugInteractionDomainCapability {

    @Autowired
    private EplDrugDrugInteractionDao eplDrugDrugInteractionDao;

    private DrugDrugInteractionConverter drugDrugInteractionConverter;



    /**
     * @return the eplDrugDrugInteractionDao
     */
    public EplDrugDrugInteractionDao getEplDrugDrugInteractionDao() {
        return eplDrugDrugInteractionDao;
    }


    /**
     * @param eplDrugDrugInteractionDao the eplDrugDrugInteractionDao to set
     */
    public void setEplDrugDrugInteractionDao(EplDrugDrugInteractionDao eplDrugDrugInteractionDao) {
        this.eplDrugDrugInteractionDao = eplDrugDrugInteractionDao;
    }



    /**
     * @return the drugDrugInteractionConverter
     */
    public DrugDrugInteractionConverter getDrugDrugInteractionConverter() {
        return drugDrugInteractionConverter;
    }



    /**
     * @param drugDrugInteractionConverter the drugDrugInteractionConverter to set
     */
    public void setDrugDrugInteractionConverter(DrugDrugInteractionConverter drugDrugInteractionConverter) {
        this.drugDrugInteractionConverter = drugDrugInteractionConverter;
    }



    /**
     * Insert the given {@link ManagedItemVo} with a duplicate check.
     * 
     * @param managedItem {@link ManagedItemVo}
     * @param user {@link UserVo} performing the action
     * @return {@link ManagedItemVo} inserted with new ID
     * @throws DuplicateItemException if item already exists by uniqueness fields
     */
    @Override
    public DrugDrugInteractionVo create(DrugDrugInteractionVo drugInteractionVo, UserVo user) throws DuplicateItemException {
        Long id = getSeqNumDomainCapability().generateIen("EPL_DRUG_DRUG_INTERACTION", user);
        drugInteractionVo.setDrugDrugInteractionIen(id.toString());

        if (existsByUniquenessFields(drugInteractionVo)) {
            throw new DuplicateItemException(DuplicateItemException.DUPLICATE_DRUG_INTERACTION, drugInteractionVo.convertToInteractionName(drugInteractionVo));
        }

        return createWithoutDuplicateCheck(drugInteractionVo, user);

    }



    /**
     * Return the {@link Converter} instance for this capability.
     * 
     * @return {@link Converter}
     */
    @Override
    public Converter<DrugDrugInteractionVo, EplDrugDrugInteractionDo> getConverter() {

        return drugDrugInteractionConverter;
    }

    /**
     * Get the {@link DataAccessObject} that this capability uses.
     * 
     * @return {@link DataAccessObject}
     */
    @Override
    public DataAccessObject getDataAccessObject() {
        return eplDrugDrugInteractionDao;
    }

    /**
     * Create Hibernate {@link Criteria} that will find an item by its uniqueness fields.
     * 
     * @param item {@link DispenseUnitVo} for which to create uniqueness {@link Criteria}
     * @return {@link Criteria}
     */
    @Override
    protected Criteria createUniquenessCriteria(DrugDrugInteractionVo item) {

        Criteria criteria = getDataAccessObject().getCriteria();

        if(null!= item.getValue())
        {
            criteria.add(Restrictions.ilike(EplDrugDrugInteractionDo.DRUG_INTERACTION_NAME, item.getValue()));    
        }


        return criteria;
    }

    // This is needed.
    @Override
    public boolean existsByUniquenessFields(DrugDrugInteractionVo interactionVo) {

        Criteria criteria = createUniquenessCriteria(interactionVo);

        criteria.add(Restrictions.ilike(EplDrugDrugInteractionDo.DRUG_INTERACTION_NAME, interactionVo.convertToInteractionName(interactionVo)));    

        int recordCount = getDataAccessObject().getCount(criteria);

        return recordCount != 0;

    }

    // This is needed.
    @Override
    public long getRevisionNumber(String id) throws ItemNotFoundException {

        return 0;
    }


    public DrugDrugInteractionVo update(DrugDrugInteractionVo drugInteractionVo, UserVo user) throws DuplicateItemException {

        EplDrugDrugInteractionDo updatedDrugDrugInteraction = drugDrugInteractionConverter.toDataObject(drugInteractionVo);

        // update attributes on product table
        eplDrugDrugInteractionDao.update(updatedDrugDrugInteraction, user);       

        return drugInteractionVo;

    }


    /**
     * To insert new record.
     */
    @Override
    public DrugDrugInteractionVo createWithoutDuplicateCheck(DrugDrugInteractionVo drugInteraction,   UserVo user) {

        // The following are needed.

        EplDrugDrugInteractionDo drugDrugInteractionDo = drugDrugInteractionConverter.toDataObject(drugInteraction);

        drugDrugInteractionDo  =  eplDrugDrugInteractionDao.insert(drugDrugInteractionDo, user);     

        drugInteraction.setId(drugDrugInteractionDo.getEplDrugDrugInteractionId().toString());

        drugInteraction.setRequestItemStatus(RequestItemStatus.APPROVED);

        drugInteraction.setValue(drugDrugInteractionDo.getInteractionName());

        drugInteraction.setNationallyEntered(String.valueOf(drugDrugInteractionDo.getNationallyEntered()?1:0));

        return drugInteraction;
    }

}
