package gov.va.med.pharmacy.peps.domain.common.capability;

import gov.va.med.pharmacy.peps.common.vo.RematchSuggestionVo;
import gov.va.med.pharmacy.peps.common.vo.UserVo;

import java.util.List;

/**
 * Perform CRUD operations on RematchSuggestionMgmts
 */
public interface RematchSuggestionMgtDomainCapability {
    
    /**
     * Retrieves all RematchSuggestionVo
     * 
     * @return Collection of RematchSuggestionVo
     */
    List<RematchSuggestionVo> retrieveAll();
    
    public void removeObsoleteProducts();

    public void addUnmatchedProducts(UserVo user);

    public List<RematchSuggestionVo> retrieveUnmatched(Long matchTypeId);

    public Long retrieveProductId(String productIen);

    public List<Object[]> findRematchProducts(Long productId);

    public RematchSuggestionVo update(Long rematchId, String matchIen, Boolean autoMatch);

}
