package gov.va.med.pharmacy.peps.domain.common.capability;

import gov.va.med.pharmacy.peps.common.vo.NationalSettingVo;
import gov.va.med.pharmacy.peps.common.vo.NdfUpdateFileVo;
import gov.va.med.pharmacy.peps.common.vo.PaginatedList;
import gov.va.med.pharmacy.peps.common.vo.SortOrder;
import gov.va.med.pharmacy.peps.common.vo.UpdateSearchCriteria;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.domain.common.model.EplNdfUpdateFileDo;

import java.util.Date;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

/**
 * Perform CRUD operations on NdfUpdateFileMgmts
 */
public interface NdfUpdateFileMgtDomainCapability<T extends NdfUpdateFileVo> {
    
    /**
     * Retrieves all NdfUpdateFileVo
     * 
     * @return Collection of NdfUpdateFileVo
     */
    List<NdfUpdateFileVo> retrieveAll();
    
    /**
     * Retrieves pending NdfUpdateFileVo
     * 
     * @return Collection of NdfUpdateFileVo
     */
    List<NdfUpdateFileVo> retrievePending();
    
    /**
     * Retrieves NdfUpdateFileVo
     * 
     * @return NdfUpdateFileVo
     */
    NdfUpdateFileVo retrieveById(Long id);
    
    /**
     * Updates the NDF update
     * 
     * @param NdfUpdateFileVo   updateFile
     *   
     * @param user
     *            provides user information
     * 
     */
    void update(NdfUpdateFileVo updatedFile, UserVo user);
    
    /**
     * Retrieves initiated NdfUpdateFileVo
     * 
     * @return Collection of NdfUpdateFileVo
     */
    List<NdfUpdateFileVo> retrieveInitiated();
    
    /**
     * Inserts the initiated NDF update
     * 
     * @param NdfUpdateFileVo   updateFile
     *   
     * @param user
     *            provides user information
     * 
     */
    NdfUpdateFileVo insert(NdfUpdateFileVo initiatedFile, UserVo user);
    
    /**
     * Retrieves the last NDF update transmitted to production 
     * 
     */
    NdfUpdateFileVo retrieveLastTranmittedToProduction();
    
     /**
     * Retrieves records in initiated status
     * 
     */
    NdfUpdateFileVo checkInitiatedFile();
    
    NdfUpdateFileVo retrieveCurrentStatus();
    
    PaginatedList<NdfUpdateFileVo> retrievePaged(UpdateSearchCriteria searchCriteria);


}
