package gov.va.med.pharmacy.peps.common.vo.validator.fields.test;

import gov.va.med.pharmacy.peps.common.exception.ValueObjectValidationException;
import gov.va.med.pharmacy.peps.common.vo.validator.fields.GCNSequenceNumberValidator;
import junit.framework.TestCase;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;

public class GCNSequenceNumberValidatorTest extends TestCase {

    private static final Logger LOG = LogManager.getLogger(GCNSequenceNumberValidatorTest.class);

    private GCNSequenceNumberValidator validator = new GCNSequenceNumberValidator();

    /**
     * Validates the validation cases for CmopId
     * @throws ValueObjectValidationException 
     */
    public void testValidGcnSeqno() {
        String gcnseqno = "111111";
        try {
            validator.validate(gcnseqno);
        } catch( ValueObjectValidationException vove ) {
            Assert.fail(gcnseqno + " is a valid value.");
        }
    }
    
    /**
     * Test a GCNSEQNO that contains non-numeric value.
     * 
     * @throws ValueObjectValidationException
     */
    public void testNonnumeric() throws ValueObjectValidationException {
        String gcnseqno = "1abcvd";
        try {
            validator.validate(gcnseqno);
            Assert.fail(gcnseqno + " is an invalid value.");
        } catch( ValueObjectValidationException vove ) {
            // Correct
        }
    }

    /**
     * Test the validation of a number that is too large to fit in to a java.lang.Long object.
     * 
     * @throws ValueObjectValidationException
     */
    public void testToolongNumber() throws ValueObjectValidationException {
        String gcnseqno = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        try {
            validator.validate(gcnseqno);
            Assert.fail(gcnseqno + " is an invalid value.");
        } catch( ValueObjectValidationException vove ) {
            // Correct
        }
    }
}
