/**
 * Source file created in 2008 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.common.vo.test;


import gov.va.med.pharmacy.peps.common.vo.SessionPreferenceType;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import junit.framework.TestCase;
import gov.va.med.pharmacy.peps.common.vo.Role;
import static org.junit.Assert.assertThat;
import static org.hamcrest.CoreMatchers.equalTo;

/**
 * Tests for the user vo
 */
public class UserVoTest extends TestCase {

    /**
     * Test
     *
     * @throws Exception Exception
     */
    public void testAddSessionPreferences() throws Exception {
        UserVo user = new UserVo();
        assertNotNull("session preferences should never be null", user.getSessionPreferences());
        
        user.getSessionPreferences().put(SessionPreferenceType.DEFAULT_SEARCH_TEMPLATE_ID, "42");
        
        assertEquals("should now hold session preference", 1, user.getSessionPreferences().size());
    }
    
    /**
     * This is the Junit test method to test removeRole method in UserVo.
     */
    public void testRemoveRole() {
        UserVo user = new UserVo();
        user.addRole(Role.LOCAL_SERVICE_MANAGER);
        user.removeRole(Role.LOCAL_SERVICE_MANAGER);
        assertThat(user.hasRole(Role.LOCAL_SERVICE_MANAGER), equalTo(false));
          
    }
}
