package gov.va.med.pharmacy.peps.common.vo.test;

import static org.junit.Assert.assertEquals;

import java.util.Set;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

import org.junit.BeforeClass;
import org.junit.Test;

/**
 * The Class FdbDomainVoDummyTest is the Junit test case for FdbDomainVoDummy.
 */
public class FdbDomainVoDummyTest {

	
	
	/** The validator. */
	private static Validator validator;

	   /**
   	 * Sets the up.
   	 */
   	@BeforeClass
	   public static void setUp() {
	      ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
	      validator = factory.getValidator();
	   }

	   /**
   	 * Fdb name is null.
   	 */
   	@Test
	   public void fdbNameIsNull() {
		   FdbDomainVoDummy fdbDomainVoDummy = new FdbDomainVoDummy( "8", "test@gmail.com", null);

	      Set<ConstraintViolation<FdbDomainVoDummy>> constraintViolations =
	      validator.validate( fdbDomainVoDummy );

	      assertEquals( 1, constraintViolations.size() );
	     
	      assertEquals(
	 	         "may not be empty",
	 	         constraintViolations.iterator().next().getMessage()
	 	      );
	   }

	   /**
   	 * Fdb domain id too low.
   	 */
   	@Test
	   public void fdbDomainIdTooLow() {
		   FdbDomainVoDummy fdbDomainVoDummy = new FdbDomainVoDummy("1", "test@gmail.com", "myName");

	      Set<ConstraintViolation<FdbDomainVoDummy>> constraintViolations = 
	      validator.validate( fdbDomainVoDummy );

	      assertEquals( 1, constraintViolations.size() );
	      assertEquals(
	         "must be between 2 and 10",
	         constraintViolations.iterator().next().getMessage()
	      );
	   }

	 /**
   	 * Fdb name too long.
   	 */
   	@Test
	   public void fdbNameTooLong() {
		   FdbDomainVoDummy fdbDomainVoDummy = new FdbDomainVoDummy("3", "test@gmail.com", "myNamemyNamemyName");

		   Set<ConstraintViolation<FdbDomainVoDummy>> constraintViolations = 
				      validator.validate( fdbDomainVoDummy );


	      assertEquals( 1, constraintViolations.size() );
	      assertEquals(
	         "length must be between 0 and 15",
	         constraintViolations.iterator().next().getMessage()
	      );
	   }
	   
	 /**
   	 * Epl domain email is not valid.
   	 */
   	@Test
	   public void eplDomainEmailIsNotValid() {
		   FdbDomainVoDummy fdbDomainVoDummy = new FdbDomainVoDummy("3", "test.com", "myName");

		   Set<ConstraintViolation<FdbDomainVoDummy>> constraintViolations = 
				      validator.validate( fdbDomainVoDummy );


	      assertEquals( 1, constraintViolations.size() );
	      assertEquals(
	         "not a well-formed email address",
	         constraintViolations.iterator().next().getMessage()
	      );
	   }

	 /**
   	 * fdbDomainVoDummy is valid.
   	 */
   	@Test
	   public void fdbDomainVoDummyIsValid() {
		   FdbDomainVoDummy fdbDomainVoDummy = new FdbDomainVoDummy("3", "test@gmail.com", "myName");

		   Set<ConstraintViolation<FdbDomainVoDummy>> constraintViolations = 
				      validator.validate( fdbDomainVoDummy );


	      assertEquals( 0, constraintViolations.size() );
	   }

}
