package gov.va.med.pharmacy.peps.common.vo.test;

import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;


/**
* FdbDomainVoDummy for test hibernate validator only
*/
public class FdbDomainVoDummy{

   private static final long serialVersionUID = 1L;
   
   @Range(min = 2, max = 10)
   private String fdbDomainId;
   @Email
   private String eplDomainEmail;
   @NotEmpty
   @Length(max = 15)
   private String fdbName;
   
   public FdbDomainVoDummy(String fdbDomainId, String eplDomainEmail, String fdbName) {
	   this.fdbDomainId = fdbDomainId;
	   this.eplDomainEmail = eplDomainEmail;
	   this.fdbName = fdbName;
   }

 
   /**
    * getId.
    * setId.
    * getFdbDomainId.
    * @return fdbDomainId
    */
   public String getFdbDomainId() {

       return fdbDomainId;
   }

   /**
    * setFdbDomainId.
    * @param fdbDomainId fdbDomainId
    */
   public void setFdbDomainId(String fdbDomainId) {

       this.fdbDomainId = fdbDomainId;
   }

  
   
   public String getFdbName() {
	return fdbName;
}

public void setFdbName(String fdbName) {
	this.fdbName = fdbName;
}


/**
    * eplDomainEmail
    * @return eplDomainEmail
    */
   public String getEplDomainEmail() {

       return eplDomainEmail;
   }

   /**
    * eplDomainEamil
    * @param eplDomainEamil eplDomainEmail
    */
   public void setEplDomainEmail(String eplDomainEmail) {

       this.eplDomainEmail = eplDomainEmail;
   }
  
 
}
