package gov.va.med.pharmacy.peps.common.vo.test;

import  static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;
import gov.va.med.pharmacy.peps.common.vo.DispenseUnitPerDoseVo;

import org.junit.Test;


/**
 * This is JUnit test case for DispenseUnitPerDoseVo class. *
 */

public class DispenseUnitPerDoseVoTest {

    /**
     * This is JUnit test method to test SetDispenseUnitPerDosIen() for various cases of trimming that occur in the logic. 
     * <ol>
     *   <li>input string has decimal point, ends in single zero</li>
     *   <li>input string has decimal point, ends in multiple zeros</li>
     *   <li>input string has decimal point, does not end in zero</li>
     *   <li>input string has no decimal point, ends in zero</li>
     *   <li>input string has no decimal point, does not end in zero</li>
     *   <li>input string is empty string</li>
     *   <li>input string with only spaces</li>
     *   <li>input string is null</li>
     *   </ol>
     */
   
    @Test
    public void testSetDispenseUnitPerDosIen() {
        
        DispenseUnitPerDoseVo doseVo = new DispenseUnitPerDoseVo();
        
        doseVo.setStrDispenseUnitPerDose("101.210");
        assertThat(doseVo.getStrDispenseUnitPerDose(), equalTo("101.21"));
      
        doseVo.setStrDispenseUnitPerDose("23.1200");
        assertThat(doseVo.getStrDispenseUnitPerDose(), equalTo("23.12"));
        
        doseVo.setStrDispenseUnitPerDose("24.22");
        assertThat(doseVo.getStrDispenseUnitPerDose(), equalTo("24.22"));
        
        doseVo.setStrDispenseUnitPerDose("250");
        assertThat(doseVo.getStrDispenseUnitPerDose(), equalTo("250"));
        
        doseVo.setStrDispenseUnitPerDose("26");
        assertThat(doseVo.getStrDispenseUnitPerDose(), equalTo("26"));
        
        doseVo.setStrDispenseUnitPerDose("    ");
        assertThat(doseVo.getStrDispenseUnitPerDose(), equalTo(""));
        
        doseVo.setStrDispenseUnitPerDose("");
        assertThat(doseVo.getStrDispenseUnitPerDose(), equalTo(""));
        
        doseVo.setStrDispenseUnitPerDose(null);
        assertThat(doseVo.getStrDispenseUnitPerDose(), equalTo(null));
    
    }

}

