package gov.va.med.pharmacy.peps.common.email;

import static org.junit.Assert.assertThat;
import  static org.hamcrest.CoreMatchers.equalTo;


import org.junit.Test;


/**
 * This is Junit test case for testing Email class hasCc() method.
 *
 */
public class EmailTest {

    /**
     * This is JUnit test method to test hasCc() for various cases of Cc field. 
     * <ol>
     *   <li>Cc field has one email address</li>
     *   <li>Cc field has more than one email address</li>
     *   <li>Cc field is empty</li>
     *   <li>Cc files is null</li>
     * </ol>
     */
    @Test
    public void testHasCc() {
        
        Email email = new Email();
        email.setCc(new String[] {"test@yahoo.com"});
        assertThat(email.hasCc(), equalTo(true));
        
        email.setCc(new String[] {"test@yahoo.com","test1@gmail.com"});
        assertThat(email.hasCc(), equalTo(true));
        
        email.setCc(new String[] {""});
        assertThat(email.hasCc(), equalTo(false));
        
        email.setCc(null);
        assertThat(email.hasCc(), equalTo(false));
        

    }

}
