package gov.va.med.pharmacy.peps.common.vo.validator.datafield.string;


import gov.va.med.pharmacy.peps.common.utility.PPSConstants;
import gov.va.med.pharmacy.peps.common.vo.datafield.DataField;
import gov.va.med.pharmacy.peps.common.vo.validator.AbstractValidator;
import gov.va.med.pharmacy.peps.common.vo.validator.Errors;


/**
 * Validates the String data fields whose length should be between 0 to 200 characters.
 */
public class CommonStringLength0To200Validator extends AbstractValidator<DataField<String>> {

/**
 * Validate that the length is between 0 and 50, inclusive.
 * 
 * @param target the String Data Field
 * @param errors the errors collection
 * 
 * @see gov.va.med.pharmacy.peps.common.vo.validator.AbstractValidator
 * #validate(java.lang.Object, gov.va.med.pharmacy.peps.common.vo.validator.Errors)
 */
    public void validate(DataField<String> target, Errors errors) {
        if (target.getValue() != null && !(target.getValue().isEmpty())) {

            // the length is between 0 to 40 characters, inclusive
            rejectIfLongerThanMax(target.getValue(), PPSConstants.I200, errors, target.getKey());
        }
        
    }
}
