
package gov.va.med.pharmacy.peps.common.vo.validator;


import gov.va.med.pharmacy.peps.common.vo.FieldKey;
import gov.va.med.pharmacy.peps.common.vo.NdfUpdateFileVo;



/**
 * Validate a Partial Save object
 */
public class UpdateFileValidator extends AbstractValidator<NdfUpdateFileVo> {


    /**
     * This method validates that the Update File object is correctly filled in.
     * 
     * @param target The object that is being saved.
     * @param errors The list of errors.
     * 
     * @see gov.va.med.pharmacy.peps.common.vo.validator.AbstractValidator#validate(java.lang.Object,
     *      gov.va.med.pharmacy.peps.common.vo.validator.Errors)
     */
    public void validate(NdfUpdateFileVo target, Errors errors) {
        rejectIfNullOrEmpty(target.getComments(), errors, FieldKey.UPDATE_FILE);
    }
}
