/**
 * Source file created in 2011 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.common.vo.validator;


import gov.va.med.pharmacy.peps.common.vo.FDBSearchOptionVo;
import gov.va.med.pharmacy.peps.common.vo.FieldKey;

import org.apache.commons.lang3.StringUtils;


/**
 * FdbSearchValidator to validate FDBSearchOptionVo.
 */
public class FdbSearchValidator extends AbstractValidator<FDBSearchOptionVo> {

    /**
     * Validates that the search string is not empty and that if it is a GCN Sequence Number search, the search string is 
     * all numeric. 
     * @see gov.va.med.pharmacy.peps.common.vo.validator.AbstractValidator#validate(
     * java.lang.Object, gov.va.med.pharmacy.peps.common.vo.validator.Errors)
     */
    @Override
    public final void validate(FDBSearchOptionVo target, Errors errors) {

        String searchString = target.getFdbSearchString();
        
        if(StringUtils.isEmpty(searchString)) {
            errors.addError(ErrorKey.EMPTY_SEARCH, new Object[] { FieldKey.SEARCH_CRITERIA });

            return;
        }
        
        if (target.getFdbSearchOptionType().isGcnSeqNoSearch()) { 
            if (!StringUtils.isNumeric(searchString.trim())) {
                errors.addError(ErrorKey.COMMON_NOT_NUMERIC, new Object[] { FieldKey.SEARCH_CRITERIA });
            
                return;
            }
        }
        
    }
    
}
