package gov.va.med.pharmacy.peps.common.vo.validator;


import gov.va.med.pharmacy.peps.common.vo.DrugDrugInteractionVo;
import gov.va.med.pharmacy.peps.common.vo.FieldKey;



/**
 * @author serverbutts
 * 
 * validator for drug drug interaction.
 *
 */
public class DrugDrugInteractionValidator extends AbstractValidator<DrugDrugInteractionVo> {

    /**
     * Validates drug drug interaction.
     */
    @Override
    public void validate(DrugDrugInteractionVo value, Errors errors) {

        rejectIfTrue(isNull(value.getIngredient1()), ErrorKey.DDI_INGREDIENT1_NOT_SELECTED, errors,  FieldKey.DRUG_INGREDIENT_1);

        rejectIfTrue(isNull(value.getIngredient2()), ErrorKey.DDI_INGREDIENT2_NOT_SELECTED, errors,  FieldKey.DRUG_INGREDIENT_2);

        rejectIfTrue(isNull(value.getDrugSeverity()), ErrorKey.DDI_SEVERITY_NOT_SELECTED, errors,  FieldKey.SEVERITY);


    }
}
