package gov.va.med.pharmacy.peps.common.vo.datafield;

/**
 * This class is a typical pojo representing a basic option for front-end select dropdowns.
 * It exists only to provide the ability to present a display value that is different that 
 * internal value in the dropdown.
 *  
 * @author VHAISHEdgecK
 *
 */
public class ListOptionField {

	private String internalValue;
	private String displayValue;
	
	
	// Constructors
	/**
	 * Default constructor
	 */
	public ListOptionField() {
	}
	/**
	 * Full constructor
	 * 
	 * @param internalValue
	 * @param displayValue
	 */
	public ListOptionField(String internalValue, String displayValue) {
		this.internalValue = internalValue;
		this.displayValue = displayValue;
	}
	
	
	// Accessors/Mutators
	/**
	 * @return
	 */
	public String getInternalValue() {
		return internalValue;
	}
	/**
	 * @param internalValue
	 */
	public void setInternalValue(String internalValue) {
		this.internalValue = internalValue;
	}
	/**
	 * @return
	 */
	public String getDisplayValue() {
		return displayValue;
	}
	/**
	 * @param displayValue
	 */
	public void setDisplayValue(String displayValue) {
		this.displayValue = displayValue;
	}
	
}
