/**
 * Source file created in 2011 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.common.vo;


import java.util.Date;


/**
 * 
 * ReportCaptureNdfVo
 *
 */
public class UpdateSiteVo implements Comparable<UpdateSiteVo> {
    
    private Long siteNbr;
    private String siteName;
    private String fileName;
    private Date installDt;
    private int daysOfInstall;
    private int daysOutOfCompliance;

    public UpdateSiteVo() {
    }
    
    public UpdateSiteVo(Long siteNbr, String siteName) {
        this.siteNbr = siteNbr;
        this.siteName = siteName;
    }
    
    public Long getSiteNbr() {
    
        return siteNbr;
    }
    
    public void setSiteNbr(Long siteNbr) {
    
        this.siteNbr = siteNbr;
    }

    public Date getInstallDt() {
    
        return installDt;
    }
    
    public String getSiteName() {
    
        return siteName;
    }
    
    public void setSiteName(String siteName) {
    
        this.siteName = siteName;
    }

    public void setInstallDt(Date installDt) {
    
        this.installDt = installDt;
    }

    public int getDaysOfInstall() {
    
        return daysOfInstall;
    }

    public void setDaysOfInstall(int daysOfInstall) {
    
        this.daysOfInstall = daysOfInstall;
    }
    
    public String getFileName() {
    
        return fileName;
    }
    
    public void setFileName(String fileName) {
    
        this.fileName = fileName;
    }
    
    public int getDaysOutOfCompliance() {
    
        return daysOutOfCompliance;
    }
    
    public void setDaysOutOfCompliance(int daysOutOfCompliance) {
    
        this.daysOutOfCompliance = daysOutOfCompliance;
    }

    public int compareTo(UpdateSiteVo compareCompliantSiteVo) {
        return this.getSiteName().compareTo(compareCompliantSiteVo.getSiteName());
    }
}
