package gov.va.med.pharmacy.peps.common.vo;


public enum Status {
    
    /** APPROVED */   
    APPROVED("Approved"),
    
    /** REJECTED */   
    REJECTED("Rejected"),
    
    /** NONE */   
    NONE("--Select--");    
   

    private String displayValue;   
    private String value;

    /**
     * constructor
     *
     * @param displayVal String
     * @param val String
     */
    private Status(String displayVal) {
        setDisplayValue(displayVal);        
        this.setValue(this.toString());        
    }    
    
    
    /**
     * getValues
     * 
     * @return Status [] of APPROVED, REJECTED, NONE only
     */
    public static Status[] getValues() {
        return (new Status[] {Status.NONE,Status.APPROVED, Status.REJECTED});
    }

    

    /**
     * isApproved
     * 
     * @return boolean true if this ItemStatus is APPROVED
     */
    public boolean isApproved() {
        return APPROVED.equals(this);
    }
    
    /**
     * isRejected
     * 
     * @return boolean true if this ItemStatus is REJECTED
     */
    public boolean isRejected() {
        return REJECTED.equals(this);
    }  
    
    /**
     * isNone
     * 
     * @return boolean true if this ItemStatus is NONE
     */
    public boolean isNone() {
        return NONE.equals(this);
    }      
   

    /**
     * getter for value value
     *
     * @return the value
     */
    public final String getValue() {
        return value;
    }

    /**
     * setter for value of value
     *
     * @param value the value to set
     */
    public final void setValue(String value) {
        this.value = value;
    }
    
    /**
     * getter for displayValue value
     *
     * @return the displayValue
     */
    public String getDisplayValue() {
        return displayValue;
    }

    /**
     * setter for value of displayValue
     *
     * @param displayValue the displayValue to set
     */
    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }
    
    


}
