/**
 * Source file created in 2011 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.common.vo;


import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 
 * ReportCaptureNdfVo
 *
 */
public class ReportDataUpdateVo {

   private String filename;
   private Date releaseDt;
   private Date complianceDt;
   private List<UpdateSiteVo> sitesInCompliance;
   private List<UpdateSiteVo> sitesOuOfCompliance;

    public String getFilename() {
    
        return filename;
    }
    
    public void setFilename(String filename) {
    
        this.filename = filename;
    }
    
    public Date getReleaseDt() {
    
        return releaseDt;
    }
    
    public void setReleaseDt(Date releaseDt) {
    
        this.releaseDt = releaseDt;
    }
    
    public Date getComplianceDt() {
    
        return complianceDt;
    }
    
    public void setComplianceDt(Date complianceDt) {
    
        this.complianceDt = complianceDt;
    }
    
    public List<UpdateSiteVo> getSitesInCompliance() {
    
        if (sitesInCompliance == null) {
            sitesInCompliance = new ArrayList<UpdateSiteVo>();
        }
        return sitesInCompliance;
    }
    
    public void setSitesInCompliance(List<UpdateSiteVo> sitesInCompliance) {
    
        this.sitesInCompliance = sitesInCompliance;
    }
    
    public List<UpdateSiteVo> getSitesOuOfCompliance() {
    
        if (sitesOuOfCompliance == null) {
            sitesOuOfCompliance = new ArrayList<UpdateSiteVo>();
        }
        return sitesOuOfCompliance;
    }
    
    public void setSitesOuOfCompliance(List<UpdateSiteVo> sitesOuOfCompliance) {
    
        this.sitesOuOfCompliance = sitesOuOfCompliance;
    }
    
    public void addSiteInCompliance(UpdateSiteVo siteVo) {
        if (sitesInCompliance == null ) {
            sitesInCompliance = new ArrayList<UpdateSiteVo>();
        }
        sitesInCompliance.add(siteVo);
    }
}
