package gov.va.med.pharmacy.peps.common.vo;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

public class PaginationListJsonSerializer extends JsonSerializer<PaginatedList> {

	    public void serialize(PaginatedList list, JsonGenerator jgen, SerializerProvider provider)
	            throws IOException, JsonProcessingException {
	        jgen.writeStartObject();
	        jgen.writeNumberField("fullSize", list.getFullSize());
	        jgen.writeNumberField("pageSize", list.getPageSize());
	        jgen.writeNumberField("startingIndex", list.getStartIndex());
	        provider.defaultSerializeField("values", list.iterator(), jgen);
	        jgen.writeEndObject();
	    }	
}
