/**
 * Source file created in 2007 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.common.vo;


/**
 * Data representing a NDC's package size.
 */
public class PackageSizeVo extends ManagedDataVo {
    private static final long serialVersionUID = 1L;

    private String eplId;
    private Double packageSize;
    private String ndfPackageSizeIen;

    /**
     * getEplId.
     * @return eplId property
     */
    public String getEplId() {
        return eplId;
    }

    /**
     * setEplId for PackageSizeVo
     * @param eplId id property
     */
    public void setEplId(String eplId) {
        this.eplId = eplId;
    }

    /**
     * getPackageSize for PackageSizeVo.
     * @return packageSize property
     */
    public Double getPackageSize() {
        return packageSize;
    }

    /**
     * setPackageSize for PackageSizeVo.
     * 
     * @param packageSize packageSize property
     */
    public void setPackageSize(Double packageSize) {
        this.packageSize = packageSize;
    }

    /**
     * packageSize
     * 
     * @return ndfPackageSizeIen property
     */
    public String getNdfPackageSizeIen() {
        return ndfPackageSizeIen;
    }

    /**
     * setNdfPackageSizeIen
     * 
     * @param ndfPackageSizeIen ndfPackageSizeIen property
     */
    public void setNdfPackageSizeIen(String ndfPackageSizeIen) {
        this.ndfPackageSizeIen = trimToEmpty(ndfPackageSizeIen);
    }
    
    /**
     * Returns true if the domain is standardized for PackageTypeVo
     * 
     * @return boolean
     */
    @Override
    public boolean isStandardized() {
        return false;
    }
    
    /**
     * Returns true if this is a local only domain  for PackageTypeVo
     * 
     * @return boolean
     */
    @Override
    public boolean isLocalOnlyData() {
        return false;
    }

    @Override
    public boolean isNdf() {

        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public DomainGroup getDomainGroup() {

        // TODO Auto-generated method stub
        return null;
    }

}
