package gov.va.med.pharmacy.peps.common.vo;


import gov.va.med.pharmacy.peps.common.vo.ValueObject;


/**
 * Drug warning labels from the drug data vendor interface.
 */
public class FdbPlblwarningsVVo extends ValueObject {

    private static final long serialVersionUID = 1L;
    
    // these are the fields of the drug monograph.
    private Long languageId;
    private String lwId;
    private Long sequenceNumber;
    private String warningText;
    private String genderCode;
    private String ageCode;
    private Long pregnancyInd;
    private String informationalCode;


    /**
     * default constructor
     */
    public FdbPlblwarningsVVo() {
    }

    /**
     * @return the languageId
     */
    public Long getLanguageId() {
    
        return languageId;
    }

    /**
     * @param languageId the languageId to set
     */
    public void setLanguageId(Long languageId) {
    
        this.languageId = languageId;
    }

    /**
     * @return the lWId
     */
    public String getLwId() {
    
        return lwId;
    }

    /**
     * @param lwId the lWId to set
     */
    public void setLwId(String lwId) {
    
        this.lwId = lwId;
    }

    /**
     * @return the sequenceNumber
     */
    public Long getSequenceNumber() {
    
        return sequenceNumber;
    }

    /**
     * @param sequenceNumber the sequenceNumber to set
     */
    public void setSequenceNumber(Long sequenceNumber) {
    
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * @return the warningText
     */
    public String getWarningText() {
    
        return warningText;
    }

    /**
     * @param warningText the warningText to set
     */
    public void setWarningText(String warningText) {
    
        this.warningText = warningText;
    }

    /**
     * @return the genderCode
     */
    public String getGenderCode() {
    
        return genderCode;
    }

    /**
     * @param genderCode the genderCode to set
     */
    public void setGenderCode(String genderCode) {
    
        this.genderCode = genderCode;
    }

    /**
     * @return the ageCode
     */
    public String getAgeCode() {
    
        return ageCode;
    }

    /**
     * @param ageCode the ageCode to set
     */
    public void setAgeCode(String ageCode) {
    
        this.ageCode = ageCode;
    }

    /**
     * @return the pregnancyInd
     */
    public Long getPregnancyInd() {
    
        return pregnancyInd;
    }

    /**
     * @param pregnancyInd the pregnancyInd to set
     */
    public void setPregnancyInd(Long pregnancyInd) {
    
        this.pregnancyInd = pregnancyInd;
    }

    /**
     * @return the informationalCode
     */
    public String getInformationalCode() {
    
        return informationalCode;
    }

    /**
     * @param informationalCode the informationalCode to set
     */
    public void setInformationalCode(String informationalCode) {
    
        this.informationalCode = informationalCode;
    }
}
