package gov.va.med.pharmacy.peps.common.vo;


import gov.va.med.pharmacy.peps.common.vo.ValueObject;


/**
 * Drug monograph from the drug data vendor interface.
 */
public class FdbMonographPemVVo extends ValueObject {

    private static final long serialVersionUID = 1L;
    
    // these are the fields of the drug monograph.
    private Long languageId;
    private String versionCode;
    private Long monographId;
    private Long sequenceNumber;
    private String sectionCode;
    private String formatCode;
    private String lineText;
    
    /**
     * default constructor
     */
    public FdbMonographPemVVo() {
    }
    
    /**
     * @return monographId
     */
    public Long getMonographId() {
        return this.monographId;
    }
    
    /**
     * setMonographID
     * @param monographId monographId
     */
    public void setMonographId(Long monographId) {
        this.monographId = monographId;
    }
    
    /**
     * @return the languageId
     */
    public Long getLanguageId() {
    
        return this.languageId;
    }
    
    /**
     * @param languageId the languageId to set
     */
    public void setLanguageId(Long languageId) {
    
        this.languageId = languageId;
    }
    
    /**
     * @return the versionCode
     */
    public String getVersionCode() {
    
        return this.versionCode;
    }
    
    /**
     * @param versionCode the versionCode to set
     */
    public void setVersionCode(String versionCode) {
    
        this.versionCode = versionCode;
    }
    
    /**
     * @return the sequenceNumber
     */
    public Long getSequenceNumber() {
    
        return this.sequenceNumber;
    }
    
    /**
     * @param sequenceNumber the sequenceNumber to set
     */
    public void setSequenceNumber(Long sequenceNumber) {
    
        this.sequenceNumber = sequenceNumber;
    }
    
    /**
     * @return the sectionCode
     */
    public String getSectionCode() {
    
        return this.sectionCode;
    }
    
    /**
     * @param sectionCode the sectionCode to set
     */
    public void setSectionCode(String sectionCode) {
    
        this.sectionCode = sectionCode;
    }
    
    /**
     * @return the formatCode
     */
    public String getFormatCode() {
    
        return this.formatCode;
    }
    
    /**
     * @param formatCode the formatCode to set
     */
    public void setFormatCode(String formatCode) {
    
        this.formatCode = formatCode;
    }
    
    /**
     * @return the linetext
     */
    public String getLineText() {
    
        return this.lineText;
    }
    
    /**
     * @param linetext the linetext to set
     */
    public void setLineText(String lineText) {
    
        this.lineText = lineText;
    }
}
