package gov.va.med.pharmacy.peps.common.vo;

import java.util.Collection;
import java.util.Set;


/**
 * @author serverbutts
 * 
 *  Data representing a drug severity
 *
 */
public class DrugSeverityVo extends ManagedDataVo {

    private static final long serialVersionUID = 1L;

    private String severityName; // name of severity

    private String severityId; // id of severity.


    /**
     * @return the severityName
     */
    public String getSeverityName() {

        return severityName;
    }


    /**
     * @param severityName the severityName to set
     */
    public void setSeverityName(String severityName) {

        this.severityName = severityName;
    }


    /**
     * @return the severityId
     */
    public String getSeverityId() {

        return severityId;
    }


    /**
     * @param severityId the severityId to set
     */
    public void setSeverityId(String severityId) {

        this.severityId = severityId;
    }



    /**
     * Returns true if the domain is standardized for DrugSeverityVo
     * 
     * @return boolean
     */
    @Override
    public boolean isStandardized() {

        return true;
    }

    /**
     * Returns true if the domain is an NDF domain for DrugSeverityVo
     * 
     * @return boolean
     */
    @Override
    public boolean isNdf() {

        return false;
    }

    @Override
    public DomainGroup getDomainGroup() {

        return DomainGroup.GROUP_7;
    }


    /**
     * Returns true if this is a local only domain for DrugSeverityVo
     * 
     * @return boolean
     */
    @Override
    public boolean isLocalOnlyData() {

        return false;
    }


    /**
     * Returns the entity for the managed item
     * 
     * @return EntityType
     */
    public EntityType getEntityType() {

        return EntityType.DRUG_SEVERITY;
    }


    /**
     * List all disabled fields for this ValueObject, with the pre-condition that the current instance is not a new one, nor
     * a read-only one for DrugSeverityVo.
     * 
     * @param environment the current {@link Environment}
     * @param roles Collection of {@link Role} instances for the current user
     * @return Set<FieldKey> All disabled fields for this object.
     */
    @SuppressWarnings("rawtypes")
    protected Set<FieldKey> handleListDisabledFields(Environment environment, Collection<Role> roles) {

        Set<FieldKey> fields = super.handleListDisabledFields(environment, roles);

        return fields;
    }


    /**
     * Used to remove the drop down field when adding a new  severity.
     * 
     * @return collection
     */
    @SuppressWarnings("rawtypes")
    public Collection<FieldKey> listAllSeverityFields() {

        Collection<FieldKey> fields = listAllWizardFields();        
        fields.add(FieldKey.SEVERITY);
        return fields;
    }

    /**
     * Returns fields used in the Add severity wizard.
     *
     * @return Collection
     */
    @SuppressWarnings("rawtypes")
    public Collection<FieldKey> getAllSeverityFields() {

        return listAllSeverityFields();
    }



}
