package gov.va.med.pharmacy.peps.common.vo;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;




/**
 * @author serverbutts
 * 
 * Data representing a Drug Drug interaction
 *
 */
public class DrugDrugInteractionVo extends ManagedDataVo {


    private static final long serialVersionUID = 1L;

    private String drugDrugInteractionIen;

    private PrimaryIngredientVo  ingredient1; // ingredient1 relating to  ingredient in EPL_INGREDIENTS

    private PrimaryIngredientVo ingredient2; //  ingredient2 relating to  ingredient in EPL_INGREDIENTS

    private DrugSeverityVo drugSeverity; // name of severity 

    private String nationallyEntered;

    private String locallyEdited;

    private String totalIndexes;

    private String drugDrugInteractionDisplay;
    
    private static final String FORWARD_SLASH ="/";

    public DrugDrugInteractionVo() {

        super();

    }



    /**
     * @return the drugDrugInteractionIen
     */
    public String getDrugDrugInteractionIen() {

        return drugDrugInteractionIen;
    }



    /**
     * @param drugDrugInteractionIen the drugDrugInteractionIen to set
     */
    public void setDrugDrugInteractionIen(String drugDrugInteractionIen) {

        this.drugDrugInteractionIen = drugDrugInteractionIen;
    }


    /**
     * @return the ingredient1
     */
    public IngredientVo getIngredient1() {

        return ingredient1;
    }



    /**
     * @param ingredient1 the ingredient1 to set
     */
    public void setIngredient1(PrimaryIngredientVo ingredient1) {

        this.ingredient1 = ingredient1;
    }



    /**
     * @return the ingredient2
     */
    public IngredientVo getIngredient2() {

        return ingredient2;
    }



    /**
     * @param ingredient2 the ingredient2 to set
     */
    public void setIngredient2(PrimaryIngredientVo ingredient2) {

        this.ingredient2 = ingredient2;
    }



    /**
     * @return the drugSeverity
     */
    public DrugSeverityVo getDrugSeverity() {

        return drugSeverity;
    }



    /**
     * @param drugSeverity the drugSeverity to set
     */
    public void setDrugSeverity(DrugSeverityVo drugSeverity) {

        this.drugSeverity = drugSeverity;
    }



    /**
     * @return the nationallyEntered
     */
    public String getNationallyEntered() {

        return nationallyEntered;
    }




    /**
     * @param nationallyEntered the nationallyEntered to set
     */
    public void setNationallyEntered(String nationallyEntered) {

        this.nationallyEntered = nationallyEntered;
    }




    /**
     * @return the locallyEdited
     */
    public String getLocallyEdited() {

        return locallyEdited;
    }




    /**
     * @param locallyEdited the locallyEdited to set
     */
    public void setLocallyEdited(String locallyEdited) {

        this.locallyEdited = locallyEdited;
    }




    /**
     * @return the totalIndexes
     */
    public String getTotalIndexes() {

        return totalIndexes;
    }




    /**
     * @param totalIndexes the totalIndexes to set
     */
    public void setTotalIndexes(String totalIndexes) {

        this.totalIndexes = totalIndexes;
    }


    /**
     * @return the drugDrugInteractionDisplay
     */
    public String getDrugDrugInteractionDisplay() {

        return drugDrugInteractionDisplay;
    }


    /**
     * @param drugDrugInteractionDisplay the drugDrugInteractionDisplay to set
     */
    public void setDrugDrugInteractionDisplay(String drugDrugInteractionDisplay) {

        this.drugDrugInteractionDisplay = drugDrugInteractionDisplay;
    }





    public EntityType getEntityType() {
        return EntityType.DRUG_DRUG_INTERACTION;
    }




    /* (non-Javadoc)
     * @see gov.va.med.pharmacy.peps.common.vo.ManagedDataVo#isStandardized()
     */
    @Override
    public boolean isStandardized() {

        return true;
    }

    /* (non-Javadoc)
     * @see gov.va.med.pharmacy.peps.common.vo.ManagedDataVo#isNdf()
     */
    @Override
    public boolean isNdf() {

        return false;
    }

    /* (non-Javadoc)
     * @see gov.va.med.pharmacy.peps.common.vo.ManagedDataVo#getDomainGroup()
     */
    @Override
    public DomainGroup getDomainGroup() {

        return DomainGroup.DRUG_DRUG_INTERACTION;
    }

    /* (non-Javadoc)
     * @see gov.va.med.pharmacy.peps.common.vo.ManagedItemVo#isLocalOnlyData()
     */
    @Override
    public boolean isLocalOnlyData() {

        return false;
    }

    @Override
    public boolean isTwoReviewItem() {
        return false;
    }


    /**
     * List all disabled fields for this ValueObject, with the pre-condition that the current instance is not a new one, nor
     * a read-only one.
     * 
     * @param environment the current {@link Environment}
     * @param roles Collection of {@link Role} instances for the current user
     * @return Set<FieldKey> All disabled fields for this object.
     */
    protected Set<FieldKey> handleListDisabledFields(Environment environment, Collection<Role> roles) {
        Set<FieldKey> disabledFields = super.handleListDisabledFields(environment, roles);
        disabledFields.remove(FieldKey.SEVERITY);        
        disabledFields.add(FieldKey.DRUG_DRUG_INTERACTION_DISPLAY_ONLY);
        disabledFields.add(FieldKey.DRUG_DRUG_INTERACTION);
        return disabledFields;
    }


    public Set<FieldKey> listNonEditableFields(Environment environment, Collection<Role> roles) {
        Set<FieldKey> readOnlyFields = super.listNonEditableFields(environment, roles);

        readOnlyFields.add(FieldKey.DRUG_DRUG_INTERACTION_DISPLAY_ONLY);
        readOnlyFields.add(FieldKey.DRUG_DRUG_INTERACTION);
        return readOnlyFields; 
    }


    /**
     * List all required fields for this ValueObject, with the pre-condition that the current instance is not a read-only
     * one.
     * 
     * @param environment the current {@link Environment}
     * @param roles Collection of {@link Role} instances for the current user
     * @return Set<FieldKey> All required fields for this DrugClassVo.
     */
    protected Set<FieldKey> handleListRequiredFields(Environment environment, Collection<Role> roles) {
        Set<FieldKey> requiredFields = super.handleListRequiredFields(environment, roles);
        requiredFields.remove(FieldKey.VALUE);
        requiredFields.add(FieldKey.SEVERITY);
        requiredFields.add(FieldKey.DRUG_INGREDIENT_1);
        requiredFields.add(FieldKey.DRUG_INGREDIENT_2);   
        return requiredFields;
    }

    /**
     * Returns a list of all fields appropriate for display on the wizard.
     * 
     * @return collection
     */
    public Collection<FieldKey> listAllWizardFields() {
        Collection<FieldKey> fields = super.listAllWizardFields();
        fields.add(FieldKey.SEVERITY);
        fields.add(FieldKey.DRUG_INGREDIENT_1);
        fields.add(FieldKey.DRUG_INGREDIENT_2);          

        return fields;
    }

    /**
     * List all uniqueness criteria for this ValueObject.
     * 
     * @return Set<FieldKey> All uniqueness fields for this object.
     */
    @Override
    public Set<FieldKey> listUniquenessCriteria() {
        Set<FieldKey> uniqueness = new HashSet<FieldKey>();
        uniqueness.add(FieldKey.DRUG_INGREDIENT_1);
        uniqueness.add(FieldKey.DRUG_INGREDIENT_2);
        return uniqueness;
    }
    
   
    public String convertToInteractionName(DrugDrugInteractionVo data) {
        
        if(null!=data.getIngredient1().getValue() && null!=data.getIngredient2().getValue()){          
            

        int compare = data.getIngredient1().getValue().compareTo(data.getIngredient2().getValue());

        StringBuilder interactionNameBuilder = new StringBuilder();

        if(compare <0){

            interactionNameBuilder.append((data.getIngredient1().getValue()+FORWARD_SLASH+data.getIngredient2().getValue()));
        }
        else if(compare > 0){

            interactionNameBuilder.append((data.getIngredient2().getValue()+FORWARD_SLASH+data.getIngredient1().getValue()));
        }
        else {

            interactionNameBuilder.append((data.getIngredient1().getValue()+FORWARD_SLASH+data.getIngredient2().getValue()));
        }

        return interactionNameBuilder.toString();
        
        }
        else
        {
            return "";
        }
    }




}
