/**
 * Source file created in 2007 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.common.vo;


/**
 * Data representing a Drug Class's classification type.
 */
public class DrugClassificationTypeVo extends ValueObject implements Selectable {
    /**
     * serialVersionUID.
     */
    private static final long serialVersionUID = 1L;

    /**
     * Unique identifier.
     */
    private String id;

    /**
     * The internal code value.
     */
    private String code;

    /**
     * The description value.
     */
    private String value;

    /**
     * getId.
     *
     * @return id property
     */
    @Override
    public String getId() {
        return id;
    }

    /**
     * setId.
     * @param id id property
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Get the code.
     *
     * @return String containing the code
     */
    public String getCode() {
        return code;
    }

    /**
     * Set the code.
     *
     * @param code
     *            the new code value
     */
    public void setCode(String code) {
        this.code = code;
    }

    /**
     * getValue.
     * @return value property
     */
    @Override
    public String getValue() {
        return value;
    }

    /**
     * setValue.
     * @param value value property
     */
    public void setValue(String value) {
        this.value = trimToEmpty(value);
    }

    /**
     * toShortString.
     * @return short string value
     */
    @Override
    public String toShortString() {
        return value;
    }
}
