

package gov.va.med.pharmacy.peps.common.utility;



/**
 * The Enum represents file number for a Vista File
 */
public enum VistaFileNumber {

    FIFTY_6("50.6"),
    FIFTY_607("50.607"),    
    FIFTY_608("50.608"),
    FIFTY_609("50.609"),
    FIFTY_64("50.64"),
    FIFTY_FIVE_95("55.95"),
    FIFTY_606("50.606"),
    FIFTY_68("50.68"),
    FIFTY_67("50.67"),
    FIFTY_416("50.416"),
    FIFTY_605("50.605"),
    FIFTY_SIX("56");
    
    /** The file number. */
    private final String fileNumber;

    /**
     * Instantiates a new vista file number.
     *
     * @param fileNumber the file number
     */
    VistaFileNumber(String fileNumber) {

        this.fileNumber = fileNumber;
    }

    /**
     * Gets the file number.
     *
     * @return the file number
     */
    public String getFileNumber() {

        return fileNumber;
    }
}
