package gov.va.med.pharmacy.peps.common.utility;

import org.apache.commons.lang3.StringUtils;

import gov.va.med.pharmacy.peps.common.vo.DispenseUnitVo;
import gov.va.med.pharmacy.peps.common.vo.DosageFormVo;
import gov.va.med.pharmacy.peps.common.vo.DrugClassVo;
import gov.va.med.pharmacy.peps.common.vo.DrugUnitVo;
import gov.va.med.pharmacy.peps.common.vo.GenericNameVo;
import gov.va.med.pharmacy.peps.common.vo.OrderableItemVo;
import gov.va.med.pharmacy.peps.common.vo.PossibleDosagesAutoCreate;
import gov.va.med.pharmacy.peps.common.vo.ProductPackage;
import gov.va.med.pharmacy.peps.common.vo.ProductVo;
import gov.va.med.pharmacy.peps.common.vo.diff.Difference;


public class NdfProductDataConversionUtility {
    
    private static final String BLANK = " ";  
    
    public static String getOldValueString(Difference diff){
        String oldValue = StringUtils.isNotBlank((String) diff.getOldValue()) ? (String) diff.getOldValue()
                                                                                 : BLANK;
        return oldValue;
    }
    
    public static String getNewValueString(Difference diff){
        String newValue = StringUtils.isNotBlank((String) diff.getNewValue()) ? (String) diff.getNewValue()
                                                                              : BLANK;
        return newValue;
        
    }
    
    public static String getStringValue(String value){
         return StringUtils.isNotBlank(value) ? value : BLANK;
    }
    
    public static String convertProductPackageValue(ProductPackage productPackage) {
        
        if(productPackage != null){
            if (productPackage.equals(ProductPackage.INPATIENT)) {
                return "I";
            } else if (productPackage.equals(ProductPackage.OUTPATIENT)) {
                return "O";
            } else {
                return "IO";
            }
        }
        else{
            return BLANK;
        }
    } 
    
    public static String convertDosageAutoCreate(PossibleDosagesAutoCreate autoDosage) {
        
        if(autoDosage != null){
            if (autoDosage.equals(PossibleDosagesAutoCreate.NO_POSSIBLE_DOSAGES)) {
                return "N";
            } else if (autoDosage.equals(PossibleDosagesAutoCreate.ONE_X_POSSIBLE_DOSAGES)) {
                return "O";
            } else {
                return "B";
            }            
        }
        else{
            return BLANK;            
        }
        
    }
    
    public static String convertFedSchedule(String csFedScheduleValue) {

        if (csFedScheduleValue.startsWith("0", 0)) {
            return "0";
        } else if (csFedScheduleValue.startsWith("1", 0)) {
            return "1";
        } else if (csFedScheduleValue.startsWith("2n", 0)) {
            return "2n";
        } else if (csFedScheduleValue.startsWith("2", 0)) {
            return "2";
        } else if (csFedScheduleValue.startsWith("3n", 0)) {
            return "3n";
        } else if (csFedScheduleValue.startsWith("3", 0)) {
            return "3";
        } else if (csFedScheduleValue.startsWith("4", 0)) {
            return "4";
        } else {
            return "5";
        }
    }
    
    public static String convertOldDrugClass(Difference diff){
        
        DrugClassVo oldDrugClass = (DrugClassVo) diff.getOldValue();
        return oldDrugClass.getCode() != null ? StringUtils.isNotBlank(oldDrugClass.getDrugClassIen())?
                        oldDrugClass.getDrugClassIen() : BLANK : BLANK;
        
    }

    public static String convertNewDrugClass(Difference diff, ProductVo vaProductVo){
    
        DrugClassVo drugClass = (DrugClassVo) diff.getNewValue();
        return drugClass.getCode() != null ? StringUtils.isNotBlank(vaProductVo.getPrimaryDrugClass()
            .getDrugClassIen()) ? vaProductVo.getPrimaryDrugClass().getDrugClassIen() : BLANK : BLANK;
    
    }
    
    public static String convertNewDrugClass(ProductVo vaProductVo){
        
        return vaProductVo.getPrimaryDrugClass().getCode() != null ? StringUtils.isNotBlank(vaProductVo.getPrimaryDrugClass()
            .getDrugClassIen()) ? vaProductVo.getPrimaryDrugClass().getDrugClassIen() : BLANK : BLANK;
    
    }
    
    public static String convertDispenseUnit(DispenseUnitVo dispenseUnit){
        
        return dispenseUnit != null?StringUtils.isNotBlank(dispenseUnit.getDispenseUnitIen()) ? dispenseUnit.getDispenseUnitIen() : BLANK :BLANK;
        
    }
    
    public static String convertDrugUnit(DrugUnitVo drugUnit){
        
        return drugUnit != null ? StringUtils.isNotBlank(drugUnit.getDrugUnitIen()) ? drugUnit.getDrugUnitIen() : BLANK : BLANK;
        
    }
    
    public static String convertGenericName(GenericNameVo genericName){
        
        return genericName != null ? StringUtils.isNotBlank(genericName.getGenericIen()) ? genericName.getGenericIen() : BLANK : BLANK;
        
    }
    
    public static String convertOrderableItem(OrderableItemVo orderableItem){
        
        return orderableItem.getDosageForm() != null ? StringUtils.isNotBlank(orderableItem.getDosageForm().getDosageFormIen()) ? orderableItem.getDosageForm()
                                                                                                                .getDosageFormIen() : BLANK
                                                                                                                : BLANK;        
    }
    
    public static String convertDosageForm(DosageFormVo dosageForm){
        
        return dosageForm != null ? StringUtils.isNotBlank(dosageForm.getDosageFormIen()) ? dosageForm.getDosageFormIen()
                                                                                                : BLANK
                                                                                                : BLANK;        
    }
    
    public static String convertYesNoValue(Boolean value){
        
        return value ? "Y" : "N";
        
    }
    
    public static String convertBooleanDigit(Object value){
        
        return value != null ? (Boolean) value ?"1" : "0" : BLANK;
        
    }
    
    public static String convertBooleanDigit(boolean value){
        
        return  value ?"1" : "0";
        
    }
    
    public static String convertOldBooleanBlank(Difference diff){
        
        return diff.getOldValue() != null ? (Boolean) diff.getOldValue() ? "1" : BLANK : null;
        
    }
    
    public static String convertNewBooleanBlank(Difference diff){
        
        return diff.getNewValue() != null ? (Boolean) diff.getNewValue() ? "1" : BLANK : null;
        
    }
    
    public static String convertNewBooleanBlank(boolean value){
        
        return value ? "1" : BLANK ;
        
    }    
    

}
