package gov.va.med.pharmacy.peps.common.utility;




import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.zip.ZipFile;

import javax.naming.Context;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IOUtility {

    private static final Logger LOG = LogManager.getLogger(IOUtility.class);
    public static void safeClose(Statement statement) {
        try {
            if (statement != null){
                statement.close();
            } 
        } catch (Exception exception) {
            LOG.error("Exception closing statement " + exception.toString());
        }
    }

    public static  void safeClose(PreparedStatement preparedStatement) {
        try {
            if (preparedStatement != null){
                preparedStatement.close();
            }            
        } catch (Exception exception) {
            LOG.error("Exception closing prepared statement " + exception.toString());
        }
    }

    public static void safeClose(ResultSet resultSet) {
        try {
            if (resultSet != null){
                resultSet.close();
            }
        } catch (Exception exception) {
            LOG.error("Exception closing resultSet " + exception.toString());
        }
    }

    public static void safeClose(Connection connection) {
        try {
            if (connection != null){
                connection.close();
            }
        } catch (Exception exception) {
            LOG.error("Exception closing connection " + exception.toString());
        }
    }

    public static void safeClose(InputStream inputStream) {
        try {
            if (inputStream != null){
                inputStream.close();
            }
        } catch (Exception exception) {
            LOG.error("Exception closing inputStream " + exception.toString());
        }       
    }

    public static void safeClose(OutputStream outputStream) {
        try {
            if (outputStream != null){
                outputStream.close();
            }
        } catch (Exception exception) {
            LOG.error("Exception closing outputStream " + exception.toString());
        }  
    }

    public static void safeClose(Context context) {
        try {
            if (context != null){
                context.close();
            }
        } catch (Exception exception) {
            LOG.error("Exception closing context " + exception.toString());
        }      
    }

    public static void safeFlush(OutputStream outputStream) {
        try {
            if (outputStream != null){
                outputStream.flush();
            }
        } catch (Exception exception) {
            LOG.error("Exception flushing outputStream " + exception.toString());
        }    
    }

    public static void safeClose(Reader reader) {
        try {
            if (reader != null){
                reader.close();
            }
        } catch (Exception exception) {
            LOG.error("Exception closing reader " + exception.toString());
        }       
    }

    public static void safeClose(Writer writer) {
        try {
            if (writer != null){
                writer.close();
            }
        } catch (Exception exception) {
            LOG.error("Exception closing writer " + exception.toString());
        }   
        
    }

    public static void safeClose(ZipFile zipFile) {
        try {
            if (zipFile != null){
                zipFile.close();
            }
        } catch (Exception exception) {
            LOG.error("Exception closing zipFile " + exception.toString());
        }   
    }

    public static void safeFlush(Writer writer) {
        try {
            if (writer != null){
                writer.flush();
            }
        } catch (Exception exception) {
            LOG.error("Exception closing writer " + exception.toString());
        }   
        
    }
 
}
