/**
 * 
 */


package gov.va.med.pharmacy.peps.common.object;


import gov.va.med.pharmacy.peps.common.vo.EplVistaUpdateVo;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * @author VHAISACARUSR
 *
 */
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class VistaUpdateStatus {

    @XmlElement
    private String version;
    @XmlElement
    private int site;
    @XmlElement
    private String status = "";
    @XmlElement
    @XmlJavaTypeAdapter(DateAdapter.class)
    private Date timeApplied;
    @XmlElement
    private String message = "";

    public VistaUpdateStatus() {
    }
    /**
     * @return the version
     */
    public String getVersion() {

        return version;
    }

    /**
     * @param version the version to set
     */
    public void setVersion(String version) {

        this.version = version;
    }

    /**
     * @return the site
     */
    public int getSite() {

        return site;
    }

    /**
     * @param site the site to set
     */
    public void setSite(int site) {

        this.site = site;
    }

    /**
     * @return the status
     */
    public String getStatus() {

        return status;
    }

    /**
     * @param status the status to set
     */
    public void setStatus(String status) {

        this.status = status;
    }

    /**
     * @return the timeApplied
     */
    public Date getTimeApplied() {
        // Defect 195557 - If the timeApplied was not passed in or parsed correctly, use the date/time from the server.
        if (this.timeApplied == null ) {
            this.timeApplied = new Date();
        }
        return timeApplied;
    }

    /**
     * @param timeApplied the timeApplied to set
     */
    public void setTimeApplied(Date timeApplied) {

        this.timeApplied = timeApplied;
    }

    /**
     * @return the message
     */
    public String getMessage() {

        return message;
    }

    /**
     * @param message the message to set
     */
    public void setMessage(String message) {

        this.message = message;
    }

    public EplVistaUpdateVo toVo() {

        EplVistaUpdateVo vo = new EplVistaUpdateVo();
        vo.setComments(this.getMessage());
        vo.setFileName(this.getVersion());
        vo.setSite(this.getSite());
        vo.setStatus(this.getStatus());
        vo.setTransmissionDate(this.getTimeApplied());

        return vo;
    }

    @Override
    public String toString() {

        return "VistaUpdateStatus [version=" + version + ", site=" + site + ", status=" + status + ", timeApplied="
            + timeApplied + ", message=" + message + "]";
    }
}
