package gov.va.med.pharmacy.peps.common.email;

import java.util.Arrays;


/**
 * @author serverbutts
 * @version 1.0
 * 
 * This class differs from the email class in terms of attachments. That class is mainly for 
 * populating email object for sending email without attachment. 
 *
 */
public class RichEmail extends Email{
	
    
	
	private String senderEnvironment; //env like test, prod etc.
	private String attachmentPath; // location to look for attachment
	private String attachmentName; // name of the file to be attached e.g. somereport.xls, somereport.xlsx, somereport.cvs etc.
	
		
	public String getSenderEnvironment() {
		return senderEnvironment;
	}
	public void setSenderEnvironment(String senderEnvironment) {
		this.senderEnvironment = senderEnvironment;
	}
	public String getAttachmentPath() {
		return attachmentPath;
	}
	public void setAttachmentPath(String attachmentPath) {
		this.attachmentPath = attachmentPath;
	}
	public String getAttachmentName() {
		return attachmentName;
	}
	public void setAttachmentName(String attachmentName) {
		this.attachmentName = attachmentName;
	}
    
	
	// for logging purposes. usage richEmailObj.toString() after populating the object.
	@Override
	public String toString() {
		return "RichEmailBean [to=" + Arrays.toString(super.to) +
		       ", cc=" + Arrays.toString(cc) +
		       ", from=" + from +
		       ", subject=" + subject +
		       ", emailMessage=" + emailMessage +
		       ", senderEnvironment=" + senderEnvironment +
		       ", attachmentPath=" + attachmentPath +
		       ", attachmentName=" + attachmentName + "]";
	}
   
}
