package gov.va.med.pharmacy.peps.common.email;

import java.util.Arrays;

import org.apache.commons.lang3.StringUtils;



/**
 * @author serverbutts
 * @version 1.0
 * 
 * Base class for email object.
 * The purpose of this class is have a barebone email object for sending emails without attachments.
 *
 */
public class Email 
{
	protected String[] to;
	protected String[] cc;
	protected String from;
	protected String subject; // subject of email.
	protected String emailMessage; // body of the email message.

	public Email() {
		// intentionally blank
	}
	
	public String[] getTo() {
		return to;
	}
	public void setTo(String[] to) {
		this.to = to;
	}
	
	public String[] getCc() {
		return cc;
	}

	public void setCc(String[] cc) {
		this.cc = cc;
	}
	
	public boolean hasCc(){
	    boolean hasCcField = false;
	    //iterate on each Cc to see if there is an email address in Cc.
	    if( getCc() != null && getCc().length > 0) {
            for (String aCc : getCc()) {
                if (!StringUtils.isBlank(aCc)) {
                    hasCcField = true;
                    break;
                }
            }
	    }
	    return hasCcField; 
	}
	
	public String getFrom() {
		return from;
	}
	public void setFrom(String from) {
		this.from = from;
	}
	public String getSubject() {
		return subject;
	}
	public void setSubject(String subject) {
		this.subject = subject;
	}
	public String getEmailMessage() {
		return emailMessage;
	}
	public void setEmailMessage(String emailMessage) {
		this.emailMessage = emailMessage;
	}
	
	

	// for logging purposes. usage emailObj.toString() after populating the object.
	@Override
	public String toString() {
		return "Email [to=" + Arrays.toString(to) +", cc=" + Arrays.toString(cc) +
		       ", from=" + from +
		       ", subject=" + subject +
		       ", emailMessage=" + emailMessage + "]";
	}

}
