package gov.va.med.authentication.kernel.sspi.authentication.manageable;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;  
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.Properties;
import java.util.ResourceBundle;

import weblogic.logging.NonCatalogLogger;
import weblogic.management.utils.NotFoundException;
import weblogic.management.utils.AlreadyExistsException;
import weblogic.security.spi.SecurityServices;
import java.sql.*;
import javax.sql.DataSource;

import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;

/**
 * The manageable sample authenticator's persistent state (ie. database).
 *
 * The manageable sample authenticator needs to keep a persistent
 * list of  user and group definitions.  A user has
 * a password and a list of groups that it is a member of.
 * A group has a list of other groups that it is a member of.
 *
 * This class holds this persistent state in a java properties
 * file.  The format of the file is:
 *  user.username=password,parentgroupname...  OR
 *  group.groupname=parentgroupname,...
 * That is, the user entries are prefixed by "user." and
 * the group entries are prefixed by "group."
 * Also, members list their groups (vs. groups listing
 * their members).
 *
 * While user names, group names and passwords normally have
 * no restrictions, the manageable sample authenticator doesn't allow
 * these strings to have white space at the ends or to contain
 * commas.  Also, they may not be null.
 *
 * The name of the java properties file is
 * ManageableSampleAuthenticatorRealmName.properties where RealmName
 * is the name of the realm that containing the manageable sample
 * authenticator.  Therefore, you should only configure one
 * manageable sample authenticator in a realm (otherwise, the other one
 * will vie for the same properties file).
 *
 * If the properties file doesn't exist, then create one
 * and seed it with the default user and group definitions that
 * all authenticators should create.  It also creates the
 * users and groups that are needed for the perimeter
 * authentication (identity asserter) test.
 *
 * The manageable sample authenticator's runtime implementation
 * and management mbean implementation delegate much of their
 * work to this class (via the RuntimeHelper and ManagementHelper
 * classes).
 *
 * @author Copyright (c) 2002 by BEA Systems. All Rights Reserved.
 * @author VHIT Security and Other Common Services (S&OCS)
 * @version 1.1.0.002
 */

/*package*/ final class KaajeeUserGroupDatabase
{
  // the java properties file that the users & groups are stored in:
  //private File database;
 // Connection con = null;

  // an in-memory version of these users & groups:
  private Properties data = new Properties();

  // gives access to the SecurityServices (thus auditing)
  private SecurityServices services;
  private PoolingDataSource dataSource = null;
  private static PoolableConnectionFactory poolableConnectionFactory = null;
  private String schemaname = ""; 
  private static NonCatalogLogger sLogger = new NonCatalogLogger( "SSPI_Authentication_Providers_logs" );                                                               // (so we can remove the principals we added if the login is aborted)


  /**
   * Set the SecurityServices for this provider.
   *
   * The provider's runtime implementation's initialize method
   * is passed a SecurityServices object.  This gives the provider
   * access to the auditor in case it wants to post audit events.
   * However, the provider's mbean implementation is not passed
   * the SecurityServices object.  However, both the runtime and
   * mbean implementation objects share this database object.
   * So, have the runtime set the SecurityServices object on this
   * database object.  Then, the mbean implementation can get the
   * SecurityServices object from this database object.
   *
   * @param services a SecurityServices object.
   */
  /*package*/ void setSecurityServices(SecurityServices services)
  {
	this.services = services;
  }

  /**
   * Get the SecurityServices for this provider.
   *
   * Returns the SecurityServices object that was set by the
   * provider's runtime implementation.  If the provider has
   * not been initialized (for example, it was not configured in
   * the default realm when the server was booted), then the
   * SecurityServices object will not be available.  This means
   * that the provider's mbean implementation can only audit if
   * the provider is configured in the current default realm
   * when the server was booted.
   *
   * @return a SecurityServices object that gives access to the auditor.
   * Returns null if the provider was not configured in the default
   * realm when the server was booted.
   */
  /*package*/ SecurityServices getSecurityServices()
  {
	return services;
  }

  /**
   * Get the persistent state for a database entry.
   *
   * Users and groups are stored as key/value pairs in the
   * database.  At this level, it's just opaque data.
   * The UserEntry and GroupEntry classes are responsible for
   * interpreting the key/value pairs.
   *
   * @param key a String containing the key for a user or group
   * database entry.
   *
   * @return a String containing the persistent state of the
   * user or group.  Returns null if the user or group doesn't exist.
   */
  /*package*/ String get(String key)
  {
  	// System.out.println("Kaajeeusergroupdatabase  get(String key)" + key  + "schemaname "+ schemaname);
  	String pw  = "";
  	String mygroup = "";
  	String username = "";
  	String userdata = null;
  	String groupname = "";
  	Connection conn = null;
  	ResultSet rs = null;
  	PreparedStatement userStmt1 = null;
  	PreparedStatement userStmt2 = null;
  	PreparedStatement groupStmt1 = null;
  	PreparedStatement groupStmt2 = null;
  	StringBuffer groupdata = null;
  	try {
  		conn = getConnection();
  		StringBuffer sb = new StringBuffer(key);
  		groupdata = new StringBuffer();
  		if (sb.indexOf("user.") == 0 ) 	{	    
  			username = sb.substring(5);
  			userStmt1 = conn.prepareStatement("select password from "+schemaname+".principals where name = ?");
  			userStmt1.setString(1,username);
  			//userStmt1.setString(2,username);
  			rs = userStmt1.executeQuery();
  			if (rs.next()) {
  				groupdata.append(rs.getString(1));
  				//mygroup = rs.getString(2);
  			}
  			if (rs != null)	rs.close();	
  			userStmt2 = conn.prepareStatement("select mygroup from "+schemaname+".groupmembers where principal = ?");
  			userStmt2.setString(1,username);
  			rs = userStmt2.executeQuery();
  			while (rs.next()) {
  				groupdata.append(",");
  				groupdata.append(rs.getString(1));;
  			}
  		}
  		userdata = groupdata.toString();
  		//System.out.println("before sb.tostring()"+sb.toString());
  		if (sb.indexOf("group.") ==  0) {
  			groupname = sb.substring(6);
  			groupStmt1 = conn.prepareStatement("select count(*) from "+schemaname+".principals where name = ? ");//and isuser='false'");
  			groupStmt1.setString(1,groupname);
  			rs = groupStmt1.executeQuery();
  			if (rs.next()) {
  				if (rs.getInt(1) > 0)
  					pw   = "";
  			}
  			userdata = pw;
  		}
  		rs.close();
  	}
  	catch ( SQLException e ) {
  		sLogger.debug( "Error checking for user or group existance: " +e );
  		// System.out.println("Error checking for user or group existance: " +e );
  		
  	} catch ( Exception ex ) {
  		sLogger.debug( "Error checking for user or group existance: " +ex );
  		// System.out.println("Error checking for user or group existance: " +ex );
  		
  	} finally { 
  		try {
  			if (rs != null)	rs.close();	
  		} catch (SQLException e){
  			sLogger.debug( "Error checking for Connection closed: " +e );
  			//System.out.println("Error checking for Connection closed: " +e );
  		}
  		try {
  			if (groupStmt1 != null)	groupStmt1.close();	
  		} catch (SQLException e){
  			sLogger.debug( "Error checking for Connection closed: " +e );
  			//System.out.println("Error checking for Connection closed: " +e );
  		}
  		try {
  			if (userStmt2 != null)	userStmt2.close();	
  		} catch (SQLException e){
  			sLogger.debug( "Error checking for Connection closed: " +e );
  			//System.out.println("Error checking for Connection closed: " +e );
  		}
  		try {
  			if (userStmt1 != null)	userStmt1.close();	
  		} catch (SQLException e){
  			sLogger.debug( "Error checking for Connection closed: " +e );
  			//System.out.println("Error checking for Connection closed: " +e );
  		}
  		try {
  			if (conn != null)	conn.close();
  		} catch (SQLException e){
  			sLogger.debug( "Error checking for Connection closed: " +e );
  			//System.out.println("Error checking for Connection closed: " +e );
  		}
  	}
  	
  	return userdata;
  }

  /**
   * Sets the persistent state for a database entry.
   * Creates the entry if it doesn't exist, otherwise
   * updates the entry's persistent state.
   *
   * Users and groups are stored as key/value pairs in the
   * database.  At this level, it's just opaque data.
   * The UserEntry and GroupEntry classes are responsible for
   * interpreting the key/value pairs.
   *
   * @param val a String containing the persistent state of
   * the user or group.
   */
  /*package*/ void set(String key, String val)
  {
	//System.out.println("this is usergroupdata base  and void set(String key, String val) method  key :"+ key + "  value  :"+ val);
	data.setProperty(key, val);
  }

  /**
   * Removes an entry (user or group) from the database.
   *
   * Does nothing if the entry doesn't already exist.
   *
   * @param key a String containing the key for a user or group
   * database entry.
   */
  /*package*/ void remove(String key)
  {
	data.remove(key);
  }

  /**
   * Determines if an entry (user or group) exists in the database.
   *
   * @param key a String containing the key for a database entry.
   *
   * @return a boolean indicating if the user or group exists.
   */
  /*package*/ boolean exists(String key)
  {
  	//System.out.println("KaajeeUserGroupDatabase                :"+ key);
  	boolean rtn = false;
  	String username = "";
  	String groupname = "";
  	Connection conn = null;
  	PreparedStatement userStmt = null;
  	PreparedStatement groupStmt = null;
  	ResultSet rs = null;
  	try {
  		conn = getConnection();
  		StringBuffer sb = new StringBuffer(key);
  		if (sb.indexOf("user.") == 0 ) {
  			username = sb.substring(5);
  			//System.out.println("usergropdatabase exists  username    :"+ username);
  			userStmt = conn.prepareStatement("select count(*) from "+schemaname+".Principals where name = ? ");
  			userStmt.setString(1,username);
  			rs = userStmt.executeQuery();
  			if(rs.next()){
  				if(rs.getInt(1) > 0)
  					rtn = true;
  			}
  		}
  		else
  			if (sb.indexOf("group.") ==  0) {
  				groupname = sb.substring(6);
  				//System.out.println("usergropdatabase exists  groupname    :"+ groupname);
  				groupStmt = conn.prepareStatement("select count(*) from "+schemaname+".Principals where name = ? ");//and isUser='false'");
  				groupStmt.setString(1,groupname);
  				rs = groupStmt.executeQuery();
  				if (rs.next()) {
  					if (rs.getInt(1) > 0)
  						rtn = true;
  				}
  				rs.close();
  			}
  	} catch (Exception e) {
  		sLogger.debug( "Exception occured while reading user data: " +e );
  		throw new RuntimeException("Exception occured while reading user data");
  	}
  	finally {
  		try {
  			if (rs != null)	rs.close();	
  		} catch (SQLException e) {
  			throw new RuntimeException("Error checking for Connection closed: "+ e);
  		}
  		try {
  			if (groupStmt != null)	groupStmt.close();	
  		} catch (SQLException e) {
  			throw new RuntimeException("Error checking for Connection closed: "+ e);
  		}
  		try {
  			if (userStmt != null)	userStmt.close();	
  		} catch (SQLException e) {
  			throw new RuntimeException("Error checking for Connection closed: "+ e);
  		}
  		try {
  			if (conn != null)	conn.close();
  		} catch (SQLException e) {
  			throw new RuntimeException("Error checking for Connection closed: "+ e);
  		}
  	}
  	//System.out.println("usergropdatabase exists rtn "+ rtn);
  	return rtn;
  	//return data.containsKey(key);
  }

  /**
   * Get the list of the keys for all the entries
   * (users and groups) in the database.
   *
   * @return an Enumeration of String containing the
   * keys for all the entries in the database.
   */
  /*package*/ Enumeration getKeys()
  {
	Connection conn = null;
	PreparedStatement stmtUser = null;
	PreparedStatement stmtGroup = null;
			Vector v = new Vector();
			try {
				   conn = getConnection();
				   stmtUser = conn.prepareStatement("select name from "+schemaname+".principals WHERE isuser='true'");
				   ResultSet rs = stmtUser.executeQuery();
					 while ( rs.next() ) {
						String user = "user."+ rs.getString(1);
						//System.out.println("KaajeeUserGroupDatabase   Enumeration getKeys()      :"+ user);
						v.add(user);
				     }
					 stmtUser.close();
					 rs.close();
					 stmtGroup = conn.prepareStatement("select name from "+schemaname+".principals WHERE isuser='false'");
					 ResultSet rsGroup = stmtGroup.executeQuery();
					 while ( rsGroup.next() ) {
					 String group = "group."+ rsGroup.getString( 1 );
					//System.out.println("KaajeeUserGroupDatabase   Enumeration   getKeys()      : "+ group);
							v.add(group);
					}
					rsGroup.close();
				}
			 catch ( SQLException e ) {
	    sLogger.debug( "Error checking for user or group existance: " +e );
		//System.out.println("Error checking for user or group existance: " +e );

	} catch ( Exception ex ) {
	  sLogger.debug( "Error checking for user or group existance: " +ex );
	 //System.out.println("Error checking for user or group existance: " +ex );

	} finally { 
		try{
			if (stmtUser != null)	stmtUser.close();	
			if (stmtGroup != null)	stmtGroup.close();	
			if (conn != null)	conn.close();
		}catch(SQLException sqle){
 		sLogger.debug( "Error checking for Connection closed: " +sqle );
		//System.out.println("Error checking for Connection closed: " +sqle );
		}
	}
  
  return v.elements();
  }

  /**
   * Get a user given the user's name.
   * The user may or may not exist in the database.
   * @param name a String containing the user's name.
   *
   * @return a UserEntry object representing the user.
   *
   * @throws IllegalArgumentException if the name is
   * invalid (eg. starts with whitespace).
   */
  /*package*/ KaajeeUserEntry getUser(String name)
  {
	return new KaajeeUserEntry(name, this);
  }

  /**
   * Get a group given the group's name.
   * The group may or may not exist in the database.
   *
   * @param name a String containing the group's name.
   *
   * @return a GroupEntry object representing the group.
   *
   * @throws IllegalArgumentException if the name is
   * invalid (eg. starts with whitespace).
   */
  /*package*/ KaajeeGroupEntry getGroup(String name)
  {
	return new KaajeeGroupEntry(name, this);
  }

  /**
   * Get a user given the user's name.
   * The user must already exist in the database.
   *
   * @param name a String containing the user's name.
   *
   * @return a UserEntry object representing the user.
   *
   * @throws IllegalArgumentException if the name is
   * invalid (eg. starts with whitespace).
   *
   * @throws NotFoundException if the user doesn't
   * already exist in the database.
   */
  /*package*/ KaajeeUserEntry getExistingUser(String user) throws NotFoundException
  {
	KaajeeUserEntry entry = getUser(user);
	if (entry.exists()) return entry;
	throw new NotFoundException("User \"" + user + "\" doesn't exist.");
  }

  /**
   * Get a group given the group's name.
   * The group must already exist in the database.
   *
   * @param name a String containing the group's name.
   *
   * @return a GroupEntry object representing the group.
   *
   * @throws IllegalArgumentException if the name is
   * invalid (eg. starts with whitespace).
   *
   * @throws NotFoundException if the group doesn't
   * already exist in the database.
   */
  /*package*/ KaajeeGroupEntry getExistingGroup(String group) throws NotFoundException
  {
    //System.out.println("KaajeeUserGroupDatabase    getExistingGroup"+ group);
	KaajeeGroupEntry entry = getGroup(group);
	if (entry.exists()) return entry;
	throw new NotFoundException("Group \"" + group + "\" doesn't exist.");
  }

  /**
   * Get a user or group (principal) given the principal's name.
   * The principal must already exist in the database.
   *
   * @param name a String containing the principal's name.
   *
   * @return a PrincipalEntry object representing the group.
   * It will either be a UserEntry or GroupEntry object.
   *
   * @throws IllegalArgumentException if the name is
   * invalid (eg. starts with whitespace).
   *
   * @throws NotFoundException if the principal doesn't
   * already exist in the database.
   */
  /*package*/ KaajeePrincipalEntry getExistingPrincipal(String name) throws NotFoundException
  {
	//System.out.println("KaajeeUserGroupDatabase             getExistingPrincipal(String name)        :" + name);
	KaajeePrincipalEntry entry;

	entry = getUser(name);
	if (entry.exists()) return entry;
	
	if (entry.exists()) return entry;


	throw new NotFoundException("Principal \"" + name + "\" doesn't exist.");
  }

  /**
   * Check that no principal (user or group) with this
   * name exists in the database.
   *
   * @param name a String containing the principal's name.
   *
   * @throws IllegalArgumentException if the name is
   * invalid (eg. starts with whitespace).
   *
   * @throws AlreadyExistsException if the principal
   * already exist in the database.
   */
  /*package*/ void checkDoesntExist(String name)
	throws AlreadyExistsException
  {
	if (getUser(name).exists() || getGroup(name).exists()) {
	  throw new AlreadyExistsException("\"" + name + "\" already exists.");
	}
  }

  /**
   * Write the in-memory properties list containing
   * user and group definitions to the properties file.
   */

  void updatePersistentState()
  {

  }


  /**
   * Create or re-open a manageable sample authenticator's database.
   *
   * @param mbean A ManageableSampleAuthenticatorMBean containing the
   * manageable sample authenticator's configuration data.
   */
  
  private KaajeeUserGroupDatabase(String realm)
  {
  	PreparedStatement usersStmt1 = null;
  	PreparedStatement usersStmt = null;
  	PreparedStatement groupStmt = null;
  	Connection conn = null;
  	ResultSet rs2 = null;
  	ResultSet rs1 = null;
  	ResultSet rsGroup = null;
  	String JdbcConnectURI = null;
  	Properties userprop = new Properties();
  	
  	
  	
  	/* Compute the name of the properties file that holds the user
  	 and group definitions the manageable sample authenticator in this realm.
  	 The file name is relative to where the domain is booted.*/
  	//database = new File("ManageableSampleAuthenticator" + realm + ".properties");
  	
  	if (dataSource == null) {
  		try {
  			
  			ResourceBundle prop = ResourceBundle.getBundle("KaajeeDatabase");
  			String driver = prop.getString("DriverName");
  			String dbUserId = prop.getString("dbUserID");
  			String dbpassword = prop.getString("Password");
  			schemaname = prop.getString("schema");		// 
  			JdbcConnectURI = prop.getString("db_URL");
  			userprop.put("user", dbUserId);
  			userprop.put("password", dbpassword);
  			Class.forName(driver);
  			
  			/*Properties prop = new Properties();
  			 //http://mindprod.com/jgloss/properties.html
  			  //FileInputStream in = new FileInputStream(System.getProperties().getProperty("user.dir")+"/KaajeeDatabase.properties");
  			   //prop.load(in);*/
  			//String driver = prop.getProperty("DriverName");
  			//String dbUserId = prop.getProperty("dbUserID");
  			//String dbpassword = prop.getProperty("Password");
  			//schemaname = prop.getProperty("schema");
  			//JdbcConnectURI = prop.getProperty("db_URL");
  			
  		} catch (ClassNotFoundException e) {
  			sLogger.debug( "Exception while reading user data KaajeeUserGroupDatabase: " +e );
  		} catch ( Exception e ) {
  			sLogger.debug( "Exception while reading user data KaajeeUserGroupDatabase: " +e );
  			throw new RuntimeException(	"Exception while reading user data KaajeeUserGroupDatabase" + e.getMessage());
  		}
  		
  		// First, we'll need a ObjectPool that serves as the
  		// actual pool of connections. We'll use a GenericObjectPool instance, although any ObjectPool implementation will suffice.
  		ObjectPool connectionPool = new GenericObjectPool(null);
  		// Next, we'll create a ConnectionFactory that the pool will use to create Connections.
  		// We'll use the DriverManagerConnectionFactory, using the connect string passed in the command line arguments.
  		ConnectionFactory connectionFactory = new DriverManagerConnectionFactory(JdbcConnectURI,userprop);
  		// Now we'll create the PoolableConnectionFactory, which wraps
  		// the "real" Connections created by the ConnectionFactory with the classes that implement the pooling functionality.
  		poolableConnectionFactory = new PoolableConnectionFactory(connectionFactory,connectionPool,null,null,false,true);
  		// Finally, we create the PoolingDriver itself, passing in the object pool we created.
  		dataSource = new PoolingDataSource(connectionPool);
  	}
  	
  	if (data.isEmpty()) {
  		try {
  			conn = getConnection();
  			usersStmt1 = conn.prepareStatement("SELECT name,password from "+schemaname+".principals where isuser = 'false'");
  			rsGroup = usersStmt1.executeQuery();
  			while (rsGroup.next())
  			{
  				String groupname = rsGroup.getString("name");
  				data.setProperty("group." + groupname, "");
  			}
  			rsGroup.close();
  			usersStmt = conn.prepareStatement("SELECT name,password from "+schemaname+".principals where isuser = 'true'");
  			rs1 = usersStmt.executeQuery();
  			while (rs1.next())
  			{
  				StringBuffer strVal = new StringBuffer();
  				String sUser = rs1.getString(1);
  				String sPWd = rs1.getString(2);
  				strVal.append(sPWd);
  				groupStmt = conn.prepareStatement("SELECT * from "+schemaname+".GroupMembers where principal = ?");
  				groupStmt.setString( 1, sUser );
  				rs2 = groupStmt.executeQuery();
  				while (rs2.next())
  				{
  					String sGroup = rs2.getString("myGroup");
  					strVal.append("," + sGroup);
  				}
  				if (groupStmt != null)	groupStmt.close();
  				if (rs2 != null) rs2.close();
  				data.setProperty("user."+sUser, strVal.toString());
  			}
  			if (rs1 != null) rs1.close();
  		} catch ( SQLException e ) {
  			sLogger.debug( "Exception while reading user data KaajeeUserGroupDatabase: " +e );
  			
  		} catch ( Exception e ) {
  			sLogger.debug( "Exception while reading user data KaajeeUserGroupDatabase: " +e );
  			
  		} finally {
  			try {
  				if (rs2 != null)	rs2.close();
  			} catch ( SQLException e ) {
  				sLogger.debug( "Exception  " +e );
  			}
  			try {
  				if (rs1 != null)	rs1.close();
  			} catch ( SQLException e ) {
  				sLogger.debug( "Exception  " +e );
  			}
  			try {
  				if (rsGroup != null)	rsGroup.close();
  			} catch ( SQLException e ) {
  				sLogger.debug( "Exception  " +e );
  			}
  			try {
  				if (groupStmt != null)	groupStmt.close();	
  			} catch ( SQLException e ) {
  				sLogger.debug( "Exception  " +e );
  			}
  			try {
  				if (usersStmt != null)	usersStmt.close();	
  			} catch ( SQLException e ) {
  				sLogger.debug( "Exception  " +e );
  			}
  			try {
  				if (usersStmt1 != null)	usersStmt1.close();	
  			} catch ( SQLException e ) {
  				sLogger.debug( "Exception  " +e );
  			}
  			try {
  				if (conn != null)	conn.close();
  			} catch ( SQLException e ) {
  				sLogger.debug( "Exception  " +e );
  			}
  		}
  		
  		updatePersistentState();
  		
  	}
  }
	
  // maps the realm name to its corresponding database object
  private static HashMap databases = new HashMap();

  /**
   * Create or re-open a manageable sample authenticator's database.
   *
   * There needs to be one manageable sample authenticator database object
   * for a realm, and it needs to be shared by both the provider's runtime
   * impl (used for logging in) and the provider's mbean impl (used for
   * user and group management).
   *
   * Keep a list list mapping the realm name to its corresponding database
   * object.  This allows the runtime and management impls to share the
   * same database object.
   *
   * @param mbean A ManageableSampleAuthenticatorMBean containing the
   * manageable sample authenticator's configuration data.
   */
  /*package*/ static synchronized KaajeeUserGroupDatabase getDatabase(KaajeeManageableAuthenticatorMBean mbean)
  {
	// Get the name of the realm from the manageable sample authenticator's mbean.
	String realm = mbean.getRealm().getName();

	// see if we already have a database object for this realm
	if (!databases.containsKey(realm)) {
	  // no - make one.
	  databases.put(realm, new KaajeeUserGroupDatabase(realm));
	}

	// return the database object for this realm
	return (KaajeeUserGroupDatabase)databases.get(realm);
  }
  
  private Connection getConnection() throws Exception{
		Connection connection = null;
		try{
				connection = dataSource.getConnection();
				
		} catch ( Exception e ) {
			  sLogger.debug( "Exception while trying to get database connection: " +e );
			  //System.out.println("Error checking for user or group existance: " +e );
			  throw new RuntimeException(	"Exception while reading user data KaajeeUserGroupDatabase" + e.getMessage());
		   }
		//catch (ClassNotFoundException e) {
		//			e.printStackTrace();
		//		}
		return connection;
	}

}
