package gov.va.med.authentication.kernel.sspi.authentication.manageable;

/**
 * Represents a group in the database.  The group is cached in memory.
 *
 * 
 * @author VHIT Security and Other Common Services (S&OCS)
 * @version 1.1.0.002
 */

/*package*/ class KaajeeGroupEntry extends KaajeePrincipalEntry
{
  // All group database eys are prefixed by this:
  private static final String PREFIX = "group.";

  /**
   * The constructor.
   *
   * @param name a String containing the group's name.
   *
   * @param database a UserGroupDatabase containing the
   * users and groups for the manageable sample authenticator.
   *
   * @throws IllegalArgumentException if the name is
   * invalid (eg. starts with whitespace).
   */
  /*package*/ KaajeeGroupEntry(String name, KaajeeUserGroupDatabase database)
  {
    super(PREFIX, name, database);
    if (exists()) {
      initializeGroups(getValue());
    }
  }

  /**
   * Extract the group's name from its database key.
   * If a database key for a user is passed in, return null.
   *
   * @return a String containing the group's name.
   */
  /*package*/ static String getNameFromKey(String key)
  {
    return (key.startsWith(PREFIX)) ? key.substring(PREFIX.length()) : null;
  }

  /**
   * Add this group to the database if it doesn't already exist.
   */
  /*package*/ void create()
  {
    if (!exists()) {
      update();
    }
  }

  /**
   * Write this group's persistent state to the database.
   *
   * A group's persistent state is just a comma separated list
   * of the names of the groups that immediately contain this
   * group as a member.
   */
  protected void update()
  {
    setValue(getGroupsString());
  }
}
