package gov.va.med.pharmacy.hazardous.db;

import static org.junit.Assert.*;
import gov.va.med.pharmacy.hazardous.HazardousUploadMain;
import gov.va.med.pharmacy.hazardous.parser.HazardousParserException;
import gov.va.med.pharmacy.hazardous.parser.IHazardousParser;
import gov.va.med.pharmacy.hazardous.util.Log;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class HazardousDBManagerTest {
	HazardousDBManager hazardousManager = null;
	
	public final static String CONNECTION_PROPERTIES_FILE = "src/test/resources/db.properties";

	private Properties connectionProperties;

	@Before
	public void setUp() throws Exception {
		hazardousManager = new HazardousDBManager() {
		};
		

		connectionProperties = HazardousUploadMain.getConnectionProperties(CONNECTION_PROPERTIES_FILE);
	}

	@After
	public void tearDown() throws Exception {
		if (hazardousManager != null)
			hazardousManager.close();

	}

	@Test
	public void testConnect() {
		hazardousManager.connect(connectionProperties);
		assertTrue(hazardousManager.isConnected());
	}

	@Test
	public void testClose() {
		hazardousManager.connect(connectionProperties);
		assertTrue(hazardousManager.isConnected());
		hazardousManager.close();
		assertFalse(hazardousManager.isConnected());
	}

	@Test
	public void testIsConnected() {
		assertFalse(hazardousManager.isConnected());
		hazardousManager.connect(connectionProperties);
		assertTrue(hazardousManager.isConnected());
	}

}
