package gov.va.med.pharmacy.hazardous.util;

import java.sql.ResultSetMetaData;

import org.slf4j.LoggerFactory;

public class Log {

	public static void d(Class clazz, String message) {
		LoggerFactory.getLogger(clazz).debug(message);
	}

	public static void d(String message) {
		LoggerFactory.getLogger(Log.class).debug(message);
	}

	public static void e(Class clazz, String message) {
		LoggerFactory.getLogger(clazz).error(message);
	}

	public static void e(String message) {
		LoggerFactory.getLogger(Log.class).error(message);
	}

    public static void i(String message) {
        LoggerFactory.getLogger(Log.class).info(message);
    }

	
	public static void m(ResultSetMetaData metadata) {
		try {
			Log.d("Number of columns: " + metadata.getColumnCount() + "\n");

			for (int i = 1; i <= metadata.getColumnCount(); i++) {
				Log.d("1. column-name: " + metadata.getColumnName(i)
						+ " column-label: " + metadata.getColumnLabel(i)
						+ " column-type: " + metadata.getColumnType(i));
			}

		} catch (Throwable e) {
			Log.e("Error printing metadata: " + e);
		}
	}

	public static void d(String[] message) {
		StringBuffer strb = new StringBuffer();
		for (int i = 0; i < message.length; i++) {
			strb.append(" [" + i + "] = " + message[i]);
		}
		LoggerFactory.getLogger(Log.class).debug(strb.toString());
	}
}
