package gov.va.med.pharmacy.hazardous.util;

public class Arguments {

	public static final String INPUT_FILE_ID = "-hf";
	public static final String INPUT_EXCEPTION_FILE_ID = "-hef";

	public static final String LAST_UPDATE_USER = "-u";
	
	public static final String CONN_PROPS = "-cp";

	private String inputFile;
	private String inputExceptionFile;
	
	/** The last update user to use on all the tables. 
	 * Also used by the difference creator to identify records created by this execution of the program.
	 */
	private String lastUpdateUser = "HAZWASTELOAD";

	private String action;
	
	private String connProperties;

	public boolean isValid(String[] args) {

		Log.d(getClass(), "Number of args: " + args.length);

		for (int i = 0; i < args.length; i++) {

			if (args[i].contains(INPUT_FILE_ID)) {
				inputFile = args[i].split("=")[1].trim();
			} else if (args[i].contains(INPUT_EXCEPTION_FILE_ID)) {
				inputExceptionFile = args[i].split("=")[1].trim();
			} else if (args[i].contains(CONN_PROPS)) {
				connProperties = args[i].split("=")[1].trim();		
            } else if (args[i].contains(LAST_UPDATE_USER)) {
                lastUpdateUser = args[i].split("=")[1].trim();      
			} else {
				Log.e(getClass(), "Unrecognized argument: " + args[i]);
			}
		}

		if (connProperties == null) {
			return false;
		}		
		
		if ((inputFile == null && inputExceptionFile != null)
				|| (inputFile != null && inputExceptionFile == null)) {
			return false;
		}

		return true;
	}

	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public String getInputFile() {
		return inputFile;
	}

	public void setInputFile(String inputFile) {
		this.inputFile = inputFile;
	}

	public String getInputExceptionFile() {
		return inputExceptionFile;
	}

	public void setInputExceptionFile(String inputExceptionFile) {
		this.inputExceptionFile = inputExceptionFile;
	}

	public String getConnProperties() {
		return connProperties;
	}

	public void setConnProperties(String connProperties) {
		this.connProperties = connProperties;
	}

    /**
     * Gets the last update user.
     *
     * @return the lastUpdateUser
     */
    public String getLastUpdateUser() {
        return lastUpdateUser;
    }

    /**
     * Sets the last update user.
     *
     * @param lastUpdateUser the lastUpdateUser to set
     */
    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser;
    }

}
