package gov.va.med.pharmacy.hazardous.db;

import gov.va.med.pharmacy.hazardous.util.Log;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public abstract class HazardousDBManager {

	public static String KEY_DBURL  = "db.url";
	public static String KEY_DBUSER = "db.user";
	public static String KEY_DBPASS = "db.password";
	
	private String dbConnectionString;
	private String user;
	private String password;

	protected Connection connection = null;

	protected void connect(Properties connectionProperties) {
		try {
			Class.forName("oracle.jdbc.driver.OracleDriver");

			getConnectionProperties(connectionProperties);
			connection = DriverManager.getConnection(dbConnectionString, user,
					password);

			Log.d(getClass(), "*** Connected to db:  " + dbConnectionString
					+ " user: " + user + " *** ");

		} catch (ClassNotFoundException e) {
			Log.e(getClass(), "Error connecting to db: " + e);
			e.printStackTrace();
		} catch (SQLException e) {
			Log.e(getClass(), "Error connecting to db: " + e);
			e.printStackTrace();
		}
	}

	protected void getDBMetaData() {
		try {
			if (connection != null && !connection.isClosed()) {
				DatabaseMetaData md = connection.getMetaData();
				ResultSet rs = md.getTables(null, null, "%", null);
				while (rs.next()) {
					Log.d(getClass(), rs.getString(3));
				}
			}
		} catch (SQLException e) {
			Log.e(getClass(), "Error retrieving metadata from db: " + e);
		}
	}

	protected void getConnectionProperties(Properties connectionProperties) {
		try {
			dbConnectionString = connectionProperties.getProperty(KEY_DBURL);
			user = connectionProperties.getProperty(KEY_DBUSER);
			password = connectionProperties.getProperty(KEY_DBPASS);
		} catch (Throwable t) {
			Log.e(getClass(), "ERROR loading DB properties: " + t);
		} 
	}

	protected void close() {
		if (connection != null) {
			try {
				connection.close();
			} catch (Throwable t) {
				Log.e(getClass(), "ERROR Closing db connection: " + t);
			} finally {
				connection = null;
			}
		}
	}

	protected boolean isConnected() {
		if (connection != null) {
			try {
				return !connection.isClosed();
			} catch (Throwable t) {
				Log.e(getClass(), "ERROR Checking db connection: " + t);
			}
		}

		return false;
	}

    /**
     * Closes the specified prepared statement, squelching any exceptions.
     * @param statement
     */
    protected void closePreparedStatementQuietly(PreparedStatement statement) {
        try {
            if (statement != null)
                statement.close();
        } catch (SQLException t) {
            return;
        }
        return;
    }
}
